/*
 * Decompiled with CFR 0.152.
 */
package simpack.measure.graph;

import org.apache.log4j.Logger;
import simpack.api.IDistanceConversion;
import simpack.api.IGraphAccessor;
import simpack.api.IGraphNode;
import simpack.api.impl.SimilarityMeasure;
import simpack.exception.InvalidElementException;

public class ShortestPath
extends SimilarityMeasure {
    static Logger logger = Logger.getLogger(ShortestPath.class);
    private IGraphAccessor graphAccessor;
    private IGraphNode nodeA;
    private IGraphNode nodeB;
    private IDistanceConversion conversion;

    public ShortestPath(IGraphAccessor accessor, IGraphNode nodeA, IGraphNode nodeB) throws InvalidElementException {
        this.graphAccessor = accessor;
        this.nodeA = nodeA;
        this.nodeB = nodeB;
        if (!accessor.contains(nodeA)) {
            throw new InvalidElementException(((Object)nodeA).toString() + " not in graph");
        }
        if (!accessor.contains(nodeB)) {
            throw new InvalidElementException(((Object)nodeB).toString() + " not in graph");
        }
    }

    public ShortestPath(IGraphAccessor accessor, IGraphNode nodeA, IGraphNode nodeB, IDistanceConversion conversion) throws InvalidElementException {
        this.graphAccessor = accessor;
        this.nodeA = nodeA;
        this.nodeB = nodeB;
        this.conversion = conversion;
        if (!accessor.contains(nodeA)) {
            throw new InvalidElementException(((Object)nodeA).toString() + " not in graph");
        }
        if (!accessor.contains(nodeB)) {
            throw new InvalidElementException(((Object)nodeB).toString() + " not in graph");
        }
    }

    public boolean calculate() {
        this.setCalculated(false);
        try {
            double distance = this.graphAccessor.getShortestPath(this.nodeA, this.nodeB);
            this.similarity = this.conversion != null ? new Double(this.conversion.convert(distance)) : new Double(distance);
            this.setCalculated(true);
            return true;
        }
        catch (InvalidElementException ex) {
            ex.printStackTrace();
            return false;
        }
    }
}

