/*
 * Decompiled with CFR 0.152.
 */
package simpack.measure.graph;

import org.apache.log4j.Logger;
import simpack.api.IGraphAccessor;
import simpack.api.IGraphNode;
import simpack.api.impl.SimilarityMeasure;
import simpack.exception.InvalidElementException;

public class ScaledShortestPath
extends SimilarityMeasure {
    static Logger logger = Logger.getLogger(ScaledShortestPath.class);
    private IGraphAccessor graphAccessor;
    private IGraphNode nodeA;
    private IGraphNode nodeB;

    public ScaledShortestPath(IGraphAccessor accessor, IGraphNode nodeA, IGraphNode nodeB) throws InvalidElementException {
        this.graphAccessor = accessor;
        this.nodeA = nodeA;
        this.nodeB = nodeB;
        if (!accessor.contains(nodeA)) {
            throw new InvalidElementException(((Object)nodeA).toString() + " not in graph");
        }
        if (!accessor.contains(nodeB)) {
            throw new InvalidElementException(((Object)nodeB).toString() + " not in graph");
        }
    }

    public boolean calculate() {
        this.setCalculated(false);
        try {
            double distance = this.graphAccessor.getShortestPath(this.nodeA, this.nodeB);
            double max = this.graphAccessor.getMaximumDirectedPathLength();
            this.similarity = distance == 0.0 ? new Double(0.0) : new Double(-1.0 * Math.log(distance / (2.0 * max)));
            this.setCalculated(true);
            return true;
        }
        catch (InvalidElementException ex) {
            ex.printStackTrace();
            return false;
        }
    }
}

