/*
 * Decompiled with CFR 0.152.
 */
package simpack.measure.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import simpack.api.IGraphAccessor;
import simpack.api.IGraphNode;
import simpack.measure.graph.MaxCommonSubgraphIsoValiente;
import simpack.util.graph.Clique;
import simpack.util.graph.MappedVertex;
import simpack.util.graph.comparator.MappedVertexComparator;
import simpack.util.graph.comparator.NamedGraphNodeComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaxGraphIsoCoveringValiente
extends MaxCommonSubgraphIsoValiente {
    public static Logger logger = Logger.getLogger(MaxGraphIsoCoveringValiente.class);
    public static String DEFAULT_GRAPH_TO_COVER = "larger";
    public static boolean DEFAULT_COVERAGE_STYLE = false;
    private String graphToCover = DEFAULT_GRAPH_TO_COVER;
    private boolean bothDisjointCoverage = DEFAULT_COVERAGE_STYLE;
    private TreeMap<Integer, ArrayList<Clique>> iso;
    private ArrayList<Clique> covering;

    public MaxGraphIsoCoveringValiente(IGraphAccessor graphAccessor1, IGraphAccessor graphAccessor2) {
        super(graphAccessor1, graphAccessor2, MaxCommonSubgraphIsoValiente.DEFAULT_MIN_CLIQUE_SIZE, MaxCommonSubgraphIsoValiente.DEFAULT_STRUCTURE_WEIGHT, MaxCommonSubgraphIsoValiente.DEFAULT_LABEL_WEIGHT, MaxCommonSubgraphIsoValiente.DEFAULT_DENOMINATOR);
        this.iso = new TreeMap();
    }

    public MaxGraphIsoCoveringValiente(IGraphAccessor graphAccessor1, IGraphAccessor graphAccessor2, int minCliqueSize, double structureWeight, double labelWeight, String denominator, String graphToCover, boolean bothDisjointCoverage) {
        super(graphAccessor1, graphAccessor2, minCliqueSize, structureWeight, labelWeight, denominator);
        this.graphToCover = graphToCover;
        this.bothDisjointCoverage = bothDisjointCoverage;
        this.iso = new TreeMap();
    }

    @Override
    public void nextMaximalClique(TreeSet<MappedVertex> candidates, TreeSet<MappedVertex> visited, TreeSet<MappedVertex> clique, int shortest) {
        ++this.countLoop;
        if (Math.IEEEremainder(this.countLoop, 2000000.0) == 0.0) {
            logger.debug((Object)("countLoop: " + this.countLoop));
        }
        TreeSet<MappedVertex> clique2 = new TreeSet<MappedVertex>(new MappedVertexComparator());
        for (MappedVertex copy : clique) {
            clique2.add(copy);
        }
        if (candidates.isEmpty()) {
            if (visited.isEmpty() && clique2.size() >= shortest) {
                double sim;
                Clique c;
                int key;
                ++this.countCliq;
                if (Math.IEEEremainder(this.countCliq, 200000.0) == 0.0) {
                    logger.debug((Object)("Cliq: " + this.countCliq + " " + clique2));
                }
                if (this.iso.containsKey(key = (c = new Clique(clique2, sim = this.getCliqueSimilarity(clique2), true)).getClique().size())) {
                    ArrayList<Clique> list = this.iso.get(c.getClique().size());
                    list.add(c);
                } else {
                    ArrayList<Clique> list = new ArrayList<Clique>();
                    list.add(c);
                    this.iso.put(key, list);
                }
            }
        } else {
            if (clique2.size() >= shortest) {
                ArrayList<Object> list;
                double sim = this.getCliqueSimilarity(clique2);
                Clique c = new Clique(clique2, sim, false);
                int key = c.getClique().size();
                if (this.iso.containsKey(key)) {
                    list = this.iso.get(key);
                    if (!list.contains(c)) {
                        list.add(c);
                    }
                } else {
                    list = new ArrayList<Clique>();
                    list.add(c);
                    this.iso.put(key, list);
                }
            }
            while (!candidates.isEmpty()) {
                MappedVertex v = candidates.first();
                candidates.remove(v);
                TreeSet<MappedVertex> tempCandidates = new TreeSet<MappedVertex>(new MappedVertexComparator());
                TreeSet<MappedVertex> tempVisited = new TreeSet<MappedVertex>(new MappedVertexComparator());
                if (logger.isDebugEnabled()) {
                    System.out.println("mappedVertex: " + v);
                    System.out.println("adjacent for mappedVertex: " + this.adjacentMap.get(v));
                }
                for (MappedVertex w : (TreeSet)this.adjacentMap.get(v)) {
                    if (candidates.contains(w)) {
                        tempCandidates.add(w);
                    }
                    if (!visited.contains(w)) continue;
                    tempVisited.add(w);
                }
                clique.add(v);
                if (logger.isDebugEnabled()) {
                    System.out.println("clique: " + clique);
                    System.out.println("new candidates: " + tempCandidates);
                }
                this.nextMaximalClique(tempCandidates, tempVisited, clique, shortest);
                clique.remove(v);
                visited.add(v);
            }
        }
    }

    public void findDisjointCliques(ArrayList<Clique> resultCliques) {
        ArrayList<Clique> cliques = this.iso.get(this.iso.lastKey());
        Collections.sort(cliques);
        Clique max = cliques.get(0);
        logger.debug((Object)("Max clique found " + max.getClique().toString()));
        resultCliques.add(max);
        TreeSet<IGraphNode> nodes = new TreeSet<IGraphNode>(new NamedGraphNodeComparator());
        for (MappedVertex mv : max.getClique()) {
            if (this.graphToCover.equals("smaller")) {
                if (this.graphAccessor1.size() < this.graphAccessor2.size()) {
                    nodes.add(mv.getLeftNode());
                    continue;
                }
                nodes.add(mv.getRightNode());
                continue;
            }
            if (this.graphAccessor1.size() < this.graphAccessor2.size()) {
                nodes.add(mv.getRightNode());
                continue;
            }
            nodes.add(mv.getLeftNode());
        }
        Set<Map.Entry<Integer, ArrayList<Clique>>> entries = this.iso.entrySet();
        Iterator<Map.Entry<Integer, ArrayList<Clique>>> it = entries.iterator();
        while (it.hasNext()) {
            Map.Entry<Integer, ArrayList<Clique>> entry = it.next();
            int key = entry.getKey();
            ArrayList<Clique> list = entry.getValue();
            Iterator<Clique> iter = list.iterator();
            block2: while (iter.hasNext()) {
                Clique c = iter.next();
                for (MappedVertex mv : c.getClique()) {
                    if (this.graphToCover.equals("smaller")) {
                        if (this.graphAccessor1.size() < this.graphAccessor2.size()) {
                            if (!nodes.contains(mv.getLeftNode())) continue;
                            iter.remove();
                            continue block2;
                        }
                        if (!nodes.contains(mv.getRightNode())) continue;
                        iter.remove();
                        continue block2;
                    }
                    if (this.graphAccessor1.size() < this.graphAccessor2.size()) {
                        if (!nodes.contains(mv.getRightNode())) continue;
                        iter.remove();
                        continue block2;
                    }
                    if (!nodes.contains(mv.getLeftNode())) continue;
                    iter.remove();
                    continue block2;
                }
            }
            if (!list.isEmpty()) continue;
            it.remove();
        }
        if (!this.iso.isEmpty()) {
            this.findDisjointCliques(resultCliques);
        }
    }

    public void findBothDisjointCliques(ArrayList<Clique> resultCliques) {
        ArrayList<Clique> cliques = this.iso.get(this.iso.lastKey());
        Collections.sort(cliques);
        Clique max = cliques.get(0);
        logger.debug((Object)("Max clique found " + max.getClique().toString()));
        resultCliques.add(max);
        TreeSet<IGraphNode> leftNodes = new TreeSet<IGraphNode>(new NamedGraphNodeComparator());
        TreeSet<IGraphNode> rightNodes = new TreeSet<IGraphNode>(new NamedGraphNodeComparator());
        for (MappedVertex mv : max.getClique()) {
            leftNodes.add(mv.getLeftNode());
            rightNodes.add(mv.getRightNode());
        }
        Set<Map.Entry<Integer, ArrayList<Clique>>> entries = this.iso.entrySet();
        Iterator<Map.Entry<Integer, ArrayList<Clique>>> it = entries.iterator();
        while (it.hasNext()) {
            Map.Entry<Integer, ArrayList<Clique>> entry = it.next();
            int key = entry.getKey();
            ArrayList<Clique> list = entry.getValue();
            Iterator<Clique> iter = list.iterator();
            block2: while (iter.hasNext()) {
                Clique c = iter.next();
                for (MappedVertex mv : c.getClique()) {
                    if (leftNodes.contains(mv.getLeftNode())) {
                        iter.remove();
                        continue block2;
                    }
                    if (!rightNodes.contains(mv.getRightNode())) continue;
                    iter.remove();
                    continue block2;
                }
            }
            if (!list.isEmpty()) continue;
            it.remove();
        }
        if (!this.iso.isEmpty()) {
            this.findBothDisjointCliques(resultCliques);
        }
    }

    public TreeMap<Integer, ArrayList<Clique>> getAllIsomorphisms() {
        return this.iso;
    }

    public ArrayList<Clique> getCovering() {
        return this.covering;
    }

    @Override
    public boolean calculate() {
        if (super.calculate()) {
            this.setCalculated(true);
            this.covering = new ArrayList();
            if (this.bothDisjointCoverage) {
                this.findBothDisjointCliques(this.covering);
            } else {
                this.findDisjointCliques(this.covering);
            }
            double numCliques = this.covering.size();
            double sim = 0.0;
            sim = this.graphToCover.equals("larger") ? (this.graphAccessor1.size() >= this.graphAccessor2.size() ? -numCliques / (double)this.graphAccessor1.size() + 1.0 : -numCliques / (double)this.graphAccessor2.size() + 1.0) : (this.graphAccessor1.size() <= this.graphAccessor2.size() ? -numCliques / (double)this.graphAccessor1.size() + 1.0 : -numCliques / (double)this.graphAccessor2.size() + 1.0);
            this.similarity = new Double(sim);
            this.setCalculated(true);
            return true;
        }
        this.setCalculated(false);
        return false;
    }

    private double getCliqueSimilarity(TreeSet<MappedVertex> clique) {
        logger.debug((Object)("clique: " + clique));
        double labelSimilarity = 0.0;
        for (MappedVertex m : clique) {
            labelSimilarity += m.calculateLabelSimilarity();
        }
        double structureSimilarity = (double)clique.size() / this.graphsSize;
        double overallSimilarity = this.labelWeight * (labelSimilarity /= this.graphsSize) + this.structureWeight * structureSimilarity;
        return overallSimilarity;
    }
}

