/*
 * Decompiled with CFR 0.152.
 */
package simpack.measure.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import simpack.api.IGraphAccessor;
import simpack.api.IGraphNode;
import simpack.measure.graph.SubgraphIsomorphism;
import simpack.util.DeepCopy;
import simpack.util.graph.Clique;
import simpack.util.graph.MappedVertex;
import simpack.util.graph.comparator.MappedVertexComparator;
import simpack.util.graph.comparator.NamedGraphNodeComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaxGraphIsoCovering
extends SubgraphIsomorphism {
    public static Logger logger = Logger.getLogger(MaxGraphIsoCovering.class);
    public static String DEFAULT_COVERING = "smaller";
    private String graphToCover = DEFAULT_COVERING;
    private TreeMap<Integer, ArrayList<Clique>> iso;
    private ArrayList<Clique> covering;

    public MaxGraphIsoCovering(IGraphAccessor graphAccessor1, IGraphAccessor graphAccessor2) {
        super(graphAccessor1, graphAccessor2, DEFAULT_MIN_CLIQUE_SIZE, DEFAULT_LABEL_WEIGHT, DEFAULT_STRUCTURE_WEIGHT, DEFAULT_DENOMINATOR, NODE_GROUPING);
        this.iso = new TreeMap();
    }

    public MaxGraphIsoCovering(IGraphAccessor graphAccessor1, IGraphAccessor graphAccessor2, int minCliqueSize, double structureWeight, double labelWeight, String denominator, boolean groupNodes, String graphToCover) {
        super(graphAccessor1, graphAccessor2, minCliqueSize, structureWeight, labelWeight, denominator, groupNodes);
        this.graphToCover = graphToCover;
        this.iso = new TreeMap();
    }

    @Override
    public void nextMaximalClique(TreeSet<MappedVertex> candidates, TreeSet<IGraphNode> impossibleLeft, TreeSet<IGraphNode> impossibleRight, TreeSet<MappedVertex> clique, int shortest) {
        Clique c;
        ++this.countLoop;
        if (Math.IEEEremainder(this.countLoop, 2000000.0) == 0.0) {
            logger.debug((Object)("countLoop: " + this.countLoop));
        }
        int cliqueSize = 0;
        TreeSet<MappedVertex> clique2 = new TreeSet<MappedVertex>(new MappedVertexComparator());
        for (MappedVertex mv : clique) {
            MappedVertex copy = (MappedVertex)DeepCopy.copy(mv);
            clique2.add(copy);
        }
        for (MappedVertex mv : clique2) {
            if (mv.isGroup()) {
                cliqueSize += mv.getGroupSize();
                continue;
            }
            ++cliqueSize;
        }
        if (candidates.isEmpty()) {
            if (cliqueSize >= shortest) {
                ++this.countCliq;
                if (Math.IEEEremainder(this.countCliq, 200000.0) == 0.0) {
                    logger.debug((Object)("Cliq: " + this.countCliq + " " + clique2));
                }
                double sim = this.getCliqueSimilarity(clique2);
                c = new Clique(clique2, sim, true);
                int key = cliqueSize;
                if (this.iso.containsKey(key)) {
                    ArrayList<Clique> list = this.iso.get(key);
                    if (!list.contains(c)) {
                        list.add(c);
                    }
                } else {
                    ArrayList<Clique> list = new ArrayList<Clique>();
                    list.add(c);
                    this.iso.put(key, list);
                }
            }
        } else {
            if (clique2.size() >= shortest) {
                ArrayList<Object> list;
                double sim = this.getCliqueSimilarity(clique2);
                c = new Clique(clique2, sim, false);
                int key = cliqueSize;
                if (this.iso.containsKey(key)) {
                    list = this.iso.get(key);
                    if (!list.contains(c)) {
                        list.add(c);
                    }
                } else {
                    list = new ArrayList<Clique>();
                    list.add(c);
                    this.iso.put(key, list);
                }
            }
            while (!candidates.isEmpty()) {
                MappedVertex v = candidates.first();
                candidates.remove(v);
                this.node1 = v.getLeftNode();
                this.node2 = v.getRightNode();
                TreeSet<MappedVertex> tempCandidates = new TreeSet<MappedVertex>(new MappedVertexComparator());
                TreeSet<IGraphNode> tempImpossibleLeft = new TreeSet<IGraphNode>(new NamedGraphNodeComparator());
                TreeSet<IGraphNode> tempImpossibleRight = new TreeSet<IGraphNode>(new NamedGraphNodeComparator());
                if (logger.isDebugEnabled()) {
                    System.out.println("mappedVertex: " + v);
                    System.out.println("impossible before l: " + impossibleLeft);
                    System.out.println("impossible before r: " + impossibleRight);
                    System.out.println("adjacent for mappedVertex: " + this.adjacentMap.get(v));
                }
                for (MappedVertex w : (TreeSet)this.adjacentMap.get(v)) {
                    if (!(impossibleLeft.contains(w.getLeftNode()) || impossibleRight.contains(w.getRightNode()) || clique.contains(w))) {
                        tempCandidates.add(w);
                        continue;
                    }
                    if (!logger.isDebugEnabled()) continue;
                    System.out.println("new candidate not added: " + w);
                    System.out.println(!impossibleLeft.contains(this.node1) + " " + !impossibleRight.contains(this.node2) + " " + !clique.contains(w));
                }
                logger.debug((Object)("only new candidates: " + tempCandidates));
                for (MappedVertex w : candidates) {
                    if (logger.isDebugEnabled()) {
                        System.out.println("old candidate: " + w);
                        System.out.println(((TreeSet)this.adjacentMap.get(v)).contains(w) + " " + !w.getLeftNode().equals(this.node1) + " " + !w.getRightNode().equals(this.node2) + " " + !this.node1.getAdjacentSet().contains(w.getLeftNode()) + " " + !this.node2.getAdjacentSet().contains(w.getRightNode()));
                    }
                    if (!((TreeSet)this.adjacentMap.get(v)).contains(w) && (w.getLeftNode().equals(this.node1) || w.getRightNode().equals(this.node2) || this.node1.getAdjacentSet().contains(w.getLeftNode()) || this.node2.getAdjacentSet().contains(w.getRightNode()))) continue;
                    tempCandidates.add(w);
                }
                for (IGraphNode node : impossibleLeft) {
                    tempImpossibleLeft.add(node);
                }
                for (IGraphNode node : impossibleRight) {
                    tempImpossibleRight.add(node);
                }
                for (IGraphNode node : this.node1.getAdjacentSet()) {
                    tempImpossibleLeft.add(node);
                }
                for (IGraphNode node : this.node2.getAdjacentSet()) {
                    tempImpossibleRight.add(node);
                }
                tempImpossibleLeft.add(this.node1);
                tempImpossibleRight.add(this.node2);
                clique.add(v);
                if (logger.isDebugEnabled()) {
                    System.out.println("clique: " + clique);
                    System.out.println("all candidates: " + tempCandidates);
                    System.out.println("impossible after l: " + tempImpossibleLeft);
                    System.out.println("impossible after r: " + tempImpossibleRight);
                }
                this.nextMaximalClique(tempCandidates, tempImpossibleLeft, tempImpossibleRight, clique, shortest);
                clique.remove(v);
            }
        }
    }

    public void findDisjointCliques(ArrayList<Clique> resultCliques) {
        ArrayList<Clique> cliques = this.iso.get(this.iso.lastKey());
        Collections.sort(cliques);
        Clique max = cliques.get(0);
        logger.debug((Object)("Max clique found " + max.getClique().toString()));
        resultCliques.add(max);
        TreeSet<IGraphNode> nodes = new TreeSet<IGraphNode>(new NamedGraphNodeComparator());
        for (MappedVertex mv : max.getClique()) {
            TreeSet<MappedVertex> group;
            if (this.graphToCover.equals("smaller")) {
                if (this.graphAccessor1.size() < this.graphAccessor2.size()) {
                    if (mv.isGroup()) {
                        group = mv.getGroupMembers();
                        for (MappedVertex v : group) {
                            nodes.add(v.getLeftNode());
                        }
                        continue;
                    }
                    nodes.add(mv.getLeftNode());
                    continue;
                }
                if (mv.isGroup()) {
                    group = mv.getGroupMembers();
                    for (MappedVertex v : group) {
                        nodes.add(v.getRightNode());
                    }
                    continue;
                }
                nodes.add(mv.getRightNode());
                continue;
            }
            if (this.graphAccessor1.size() < this.graphAccessor2.size()) {
                if (mv.isGroup()) {
                    System.out.println("Adding group nodes" + mv.toString());
                    group = mv.getGroupMembers();
                    for (MappedVertex v : group) {
                        nodes.add(v.getRightNode());
                    }
                    continue;
                }
                nodes.add(mv.getRightNode());
                continue;
            }
            if (mv.isGroup()) {
                System.out.println("Adding group nodes" + mv.toString());
                group = mv.getGroupMembers();
                for (MappedVertex v : group) {
                    nodes.add(v.getLeftNode());
                }
                continue;
            }
            nodes.add(mv.getLeftNode());
        }
        Set<Map.Entry<Integer, ArrayList<Clique>>> entries = this.iso.entrySet();
        Iterator<Map.Entry<Integer, ArrayList<Clique>>> it = entries.iterator();
        while (it.hasNext()) {
            Map.Entry<Integer, ArrayList<Clique>> entry = it.next();
            int key = entry.getKey();
            ArrayList<Clique> list = entry.getValue();
            Iterator<Clique> iter = list.iterator();
            block6: while (iter.hasNext()) {
                Clique c = iter.next();
                for (MappedVertex mv : c.getClique()) {
                    boolean found;
                    TreeSet<MappedVertex> group;
                    if (this.graphToCover.equals("smaller")) {
                        if (this.graphAccessor1.size() < this.graphAccessor2.size()) {
                            if (mv.isGroup()) {
                                group = mv.getGroupMembers();
                                found = false;
                                for (MappedVertex v : group) {
                                    if (!nodes.contains(v.getLeftNode())) continue;
                                    found = true;
                                    break;
                                }
                                if (!found) continue;
                                iter.remove();
                                continue block6;
                            }
                            if (!nodes.contains(mv.getLeftNode())) continue;
                            iter.remove();
                            continue block6;
                        }
                        if (mv.isGroup()) {
                            group = mv.getGroupMembers();
                            found = false;
                            for (MappedVertex v : group) {
                                if (!nodes.contains(v.getRightNode())) continue;
                                found = true;
                                break;
                            }
                            if (!found) continue;
                            iter.remove();
                            continue block6;
                        }
                        if (!nodes.contains(mv.getRightNode())) continue;
                        iter.remove();
                        continue block6;
                    }
                    if (this.graphAccessor1.size() < this.graphAccessor2.size()) {
                        if (mv.isGroup()) {
                            group = mv.getGroupMembers();
                            found = false;
                            for (MappedVertex v : group) {
                                if (!nodes.contains(v.getRightNode())) continue;
                                found = true;
                                System.out.println("Group found: " + mv.toString());
                                break;
                            }
                            if (!found) continue;
                            System.out.println("Removing group node: " + mv.toString());
                            iter.remove();
                            continue block6;
                        }
                        if (!nodes.contains(mv.getRightNode())) continue;
                        iter.remove();
                        continue block6;
                    }
                    if (mv.isGroup()) {
                        group = mv.getGroupMembers();
                        found = false;
                        for (MappedVertex v : group) {
                            if (!nodes.contains(v.getLeftNode())) continue;
                            found = true;
                            System.out.println("Group found: " + mv.toString());
                            break;
                        }
                        if (!found) continue;
                        System.out.println("Removing group node: " + mv.toString());
                        iter.remove();
                        continue block6;
                    }
                    if (!nodes.contains(mv.getLeftNode())) continue;
                    iter.remove();
                    continue block6;
                }
            }
            if (!list.isEmpty()) continue;
            it.remove();
        }
        if (!this.iso.isEmpty()) {
            this.findDisjointCliques(resultCliques);
        }
    }

    @Override
    public boolean calculate() {
        if (super.calculate()) {
            this.setCalculated(false);
            if (this.groupNodes) {
                TreeMap<Integer, ArrayList<Clique>> map = this.getAllIsomorphisms();
                ArrayList<Clique> one = map.get(1);
                for (IGraphNode n1 : this.graphAccessor1.getNodeSet()) {
                    if (n1.getIsGroup()) continue;
                    for (IGraphNode n2 : this.graphAccessor2.getNodeSet()) {
                        if (n2.getIsGroup()) continue;
                        MappedVertex mv = new MappedVertex(n1, n2);
                        TreeSet<MappedVertex> set = new TreeSet<MappedVertex>();
                        set.add(mv);
                        double sim = (mv.calculateLabelSimilarity() + 1.0) / this.getGraphsSize() * 0.5;
                        Clique c = new Clique(set, sim, false);
                        if (one.contains(c)) continue;
                        one.add(c);
                        logger.debug((Object)("Adding clique " + c.toString()));
                    }
                }
            }
            this.covering = new ArrayList();
            this.findDisjointCliques(this.covering);
            double numCliques = this.covering.size();
            double sim = this.graphToCover.equals("larger") ? (this.graphAccessor1.size() >= this.graphAccessor2.size() ? new Double(-numCliques / (double)this.graphAccessor1.size() + 1.0).doubleValue() : new Double(-numCliques / (double)this.graphAccessor2.size() + 1.0).doubleValue()) : (this.graphAccessor1.size() <= this.graphAccessor2.size() ? new Double(-numCliques / (double)this.graphAccessor1.size() + 1.0).doubleValue() : new Double(-numCliques / (double)this.graphAccessor2.size() + 1.0).doubleValue());
            this.similarity = new Double(sim);
            this.setCalculated(true);
            return true;
        }
        this.setCalculated(false);
        logger.error((Object)"Error");
        return false;
    }

    public TreeMap<Integer, ArrayList<Clique>> getAllIsomorphisms() {
        return this.iso;
    }

    public ArrayList<Clique> getCovering() {
        return this.covering;
    }

    private double getCliqueSimilarity(TreeSet<MappedVertex> clique) {
        int groupVertexSize = 0;
        double labelSimilarity = 0.0;
        double structureSimilarity = 0.0;
        double overallSimilarity = 0.0;
        for (MappedVertex m : clique) {
            if (m.isGroup()) {
                labelSimilarity += m.getGroupSimilarity();
                groupVertexSize = groupVertexSize + m.getGroupSize() - 1;
                continue;
            }
            labelSimilarity += m.getLabelSimilarity();
        }
        structureSimilarity = (double)(clique.size() + groupVertexSize) / this.graphsSize;
        overallSimilarity = this.labelWeight * (labelSimilarity /= this.graphsSize) + this.structureWeight * structureSimilarity;
        return overallSimilarity;
    }
}

