/*
 * Decompiled with CFR 0.152.
 */
package simpack.measure.graph;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import simpack.api.IGraphAccessor;
import simpack.api.IGraphNode;
import simpack.api.impl.GraphSimilarityMeasure;
import simpack.util.graph.MappedVertex;
import simpack.util.graph.comparator.MappedVertexComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaxCommonSubgraphIsoValiente
extends GraphSimilarityMeasure {
    public static Logger logger = Logger.getLogger(MaxCommonSubgraphIsoValiente.class);
    public static String DEFAULT_NODE_LABEL_SIMILARITY_MEASURE = "Levenshtein";
    public static int DEFAULT_MIN_CLIQUE_SIZE = 2;
    public static double DEFAULT_STRUCTURE_WEIGHT = 0.5;
    public static double DEFAULT_LABEL_WEIGHT = 0.5;
    public static boolean NODE_GROUPING = false;
    public static String DEFAULT_DENOMINATOR = "average";
    protected int minCliqueSize = DEFAULT_MIN_CLIQUE_SIZE;
    protected double structureWeight = DEFAULT_STRUCTURE_WEIGHT;
    protected double labelWeight = DEFAULT_LABEL_WEIGHT;
    protected IGraphAccessor graphAccessor1;
    protected IGraphAccessor graphAccessor2;
    protected double graphsSize = 0.0;
    protected int countCliq = 0;
    protected int countLoop = 0;
    protected int countMV = 0;
    protected TreeSet<IGraphNode> nodeSet1 = new TreeSet();
    protected TreeSet<IGraphNode> nodeSet2 = new TreeSet();
    protected ArrayList<MappedVertex> mappedVertexList = new ArrayList();
    protected TreeMap<MappedVertex, TreeSet<MappedVertex>> adjacentMap = new TreeMap(new MappedVertexComparator());
    protected TreeSet<String> cliqueList = new TreeSet();
    protected double maxSimilarity = 0.0;
    protected double tmpMaxSimilarity = 0.0;
    protected int maxVertex = 0;
    protected int tmpMaxVertex = 0;
    protected String maxVertexPathWithSimNumber;
    protected String maxSimilarityPathWithSimNumber;
    protected long startMillis;
    protected Timestamp ts;
    protected long millis;
    protected Calendar eDate;

    public MaxCommonSubgraphIsoValiente(IGraphAccessor graphAccessor1, IGraphAccessor graphAccessor2) {
        this(graphAccessor1, graphAccessor2, DEFAULT_MIN_CLIQUE_SIZE, DEFAULT_STRUCTURE_WEIGHT, DEFAULT_LABEL_WEIGHT, DEFAULT_DENOMINATOR);
    }

    public MaxCommonSubgraphIsoValiente(IGraphAccessor graphAccessor1, IGraphAccessor graphAccessor2, int minCliqueSize, double structureWeight, double labelWeight, String denominator) {
        this.graphAccessor1 = graphAccessor1;
        this.graphAccessor2 = graphAccessor2;
        this.minCliqueSize = minCliqueSize;
        this.structureWeight = structureWeight;
        this.labelWeight = labelWeight;
        if (denominator.equals("first")) {
            this.graphsSize = graphAccessor1.getNodeSet().size();
        } else if (denominator.equals("small")) {
            this.graphsSize = graphAccessor1.getNodeSet().size() > graphAccessor2.getNodeSet().size() ? (double)graphAccessor2.getNodeSet().size() : (double)graphAccessor1.getNodeSet().size();
        } else if (denominator.equals("big")) {
            this.graphsSize = graphAccessor1.getNodeSet().size() > graphAccessor2.getNodeSet().size() ? (double)graphAccessor1.getNodeSet().size() : (double)graphAccessor2.getNodeSet().size();
        } else if (denominator.equals("average")) {
            this.graphsSize = (double)(graphAccessor1.getNodeSet().size() + graphAccessor2.getNodeSet().size()) / 2.0;
        } else {
            logger.debug((Object)"valid denominators are \"first\", \"small\", \"big\" and \"average\". default \"average\" is taken");
            this.graphsSize = (double)(graphAccessor1.getNodeSet().size() + graphAccessor2.getNodeSet().size()) / 2.0;
        }
    }

    @Override
    public boolean calculate() {
        this.setCalculated(false);
        TreeSet<MappedVertex> candidates = new TreeSet<MappedVertex>(new MappedVertexComparator());
        TreeSet<MappedVertex> clique = new TreeSet<MappedVertex>(new MappedVertexComparator());
        TreeSet<MappedVertex> visited = new TreeSet<MappedVertex>(new MappedVertexComparator());
        this.nodeSet1 = this.graphAccessor1.getNodeSet();
        this.nodeSet2 = this.graphAccessor2.getNodeSet();
        this.adjacentMap = this.map();
        if (logger.isDebugEnabled()) {
            for (IGraphNode n : this.graphAccessor1.getNodeSet()) {
                System.out.println("nodeG1: " + n);
                System.out.println("pre: " + n.getPredecessorSet());
                System.out.println("suc: " + n.getSuccessorSet());
            }
            for (IGraphNode n : this.graphAccessor2.getNodeSet()) {
                System.out.println("nodeG2: " + n);
                System.out.println("pre: " + n.getPredecessorSet());
                System.out.println("suc: " + n.getSuccessorSet());
            }
            Set<MappedVertex> set = this.adjacentMap.keySet();
            for (MappedVertex mv : set) {
                System.out.println(mv);
                if (mv.isGroup()) {
                    System.out.println("grpsiz " + mv.getGroupSize() + "  grpsim " + mv.getGroupSimilarity() + "  Map: " + this.adjacentMap.get(mv));
                } else {
                    System.out.println("labelsim " + mv.getLabelSimilarity() + "  Map: " + this.adjacentMap.get(mv));
                }
                for (MappedVertex n : this.adjacentMap.get(mv)) {
                    System.out.println(n + " sim " + n.getLabelSimilarity());
                }
            }
        }
        for (MappedVertex m : this.mappedVertexList) {
            ++this.countMV;
            if (Math.IEEEremainder(this.countMV, 10000.0) == 0.0) {
                this.eDate = Calendar.getInstance();
                this.millis = this.eDate.getTime().getTime();
                this.ts = new Timestamp(this.millis);
                System.out.println(this.countMV + ") " + m + " " + this.ts + " = " + (this.millis - this.startMillis) / 1000L + " sec");
            }
            candidates.add(m);
        }
        this.nextMaximalClique(candidates, visited, clique, this.minCliqueSize);
        this.similarity = this.maxSimilarity;
        this.setCalculated(true);
        return true;
    }

    public TreeMap<MappedVertex, TreeSet<MappedVertex>> map() {
        for (IGraphNode node1 : this.nodeSet1) {
            for (IGraphNode node2 : this.nodeSet2) {
                MappedVertex mvOri = new MappedVertex(node1, node2);
                TreeSet<MappedVertex> adjacentSet = new TreeSet<MappedVertex>(new MappedVertexComparator());
                for (IGraphNode cand1 : this.nodeSet1) {
                    for (IGraphNode cand2 : this.nodeSet2) {
                        MappedVertex mvCand = new MappedVertex(cand1, cand2);
                        if (mvOri.smaller(mvCand) >= 0 || node1.equals(cand1) || node2.equals(cand2) || !(node1.getPredecessorSet().contains(cand1) && node2.getPredecessorSet().contains(cand2) || node1.getSuccessorSet().contains(cand1) && node2.getSuccessorSet().contains(cand2)) && (node1.getAdjacentSet().contains(cand1) || node2.getAdjacentSet().contains(cand2))) continue;
                        adjacentSet.add(mvCand);
                    }
                }
                this.mappedVertexList.add(mvOri);
                this.adjacentMap.put(mvOri, adjacentSet);
            }
        }
        return this.adjacentMap;
    }

    public void nextMaximalClique(TreeSet<MappedVertex> candidates, TreeSet<MappedVertex> visited, TreeSet<MappedVertex> clique, int shortest) {
        ++this.countLoop;
        if (Math.IEEEremainder(this.countLoop, 2000000.0) == 0.0) {
            logger.debug((Object)("countLoop: " + this.countLoop));
        }
        TreeSet<MappedVertex> clique2 = new TreeSet<MappedVertex>(new MappedVertexComparator());
        for (MappedVertex copy : clique) {
            clique2.add(copy);
        }
        if (candidates.isEmpty()) {
            if (visited.isEmpty() && clique2.size() >= shortest) {
                ++this.countCliq;
                if (Math.IEEEremainder(this.countCliq, 200000.0) == 0.0) {
                    logger.debug((Object)("Cliq: " + this.countCliq + " " + clique2));
                }
                this.checkIfMaxClique(clique2);
            }
        } else {
            while (!candidates.isEmpty()) {
                MappedVertex v = candidates.first();
                candidates.remove(v);
                TreeSet<MappedVertex> tempCandidates = new TreeSet<MappedVertex>(new MappedVertexComparator());
                TreeSet<MappedVertex> tempVisited = new TreeSet<MappedVertex>(new MappedVertexComparator());
                if (logger.isDebugEnabled()) {
                    System.out.println("mappedVertex: " + v);
                    System.out.println("adjacent for mappedVertex: " + this.adjacentMap.get(v));
                }
                for (MappedVertex w : this.adjacentMap.get(v)) {
                    if (candidates.contains(w)) {
                        tempCandidates.add(w);
                    }
                    if (!visited.contains(w)) continue;
                    tempVisited.add(w);
                }
                clique.add(v);
                if (logger.isDebugEnabled()) {
                    System.out.println("clique: " + clique);
                    System.out.println("new candidates: " + tempCandidates);
                }
                this.nextMaximalClique(tempCandidates, tempVisited, clique, shortest);
                clique.remove(v);
                visited.add(v);
            }
        }
    }

    public void checkIfMaxClique(TreeSet<MappedVertex> clique) {
        logger.debug((Object)("clique: " + clique));
        double labelSimilarity = 0.0;
        String pathWithSimNumber = "";
        for (MappedVertex m : clique) {
            labelSimilarity += m.calculateLabelSimilarity();
            if (pathWithSimNumber.equals("")) {
                pathWithSimNumber = pathWithSimNumber + m.toString();
                continue;
            }
            pathWithSimNumber = pathWithSimNumber + ", " + m.toString();
        }
        double structureSimilarity = (double)clique.size() / this.graphsSize;
        double overallSimilarity = this.labelWeight * (labelSimilarity /= this.graphsSize) + this.structureWeight * structureSimilarity;
        if (logger.isDebugEnabled()) {
            System.out.println("clique: " + pathWithSimNumber);
            System.out.println("labelSimilarity: " + labelSimilarity);
            System.out.println("structureSimilarity: " + structureSimilarity);
            System.out.println("overallSimilarity: " + overallSimilarity);
        }
        String path = pathWithSimNumber;
        if (overallSimilarity == 1.0) {
            pathWithSimNumber = pathWithSimNumber + "; 1";
        } else {
            int tempInt = (int)(overallSimilarity * 100.0);
            Integer conversion = new Integer(tempInt);
            pathWithSimNumber = pathWithSimNumber + "; 0." + conversion.toString();
        }
        this.checkMax(clique.size(), overallSimilarity, path, pathWithSimNumber);
    }

    public void checkMax(int numVertex, double similarity, String clique, String cliqueSim) {
        if (similarity >= this.maxSimilarity) {
            if (similarity > this.maxSimilarity) {
                this.cliqueList.clear();
            }
            this.cliqueList.add(clique);
        }
        if (numVertex > this.maxVertex || numVertex == this.maxVertex && similarity > this.tmpMaxSimilarity) {
            this.maxVertexPathWithSimNumber = cliqueSim;
            logger.debug((Object)("maxVertexPathWithSimNumber: " + this.maxVertexPathWithSimNumber));
            this.maxVertex = numVertex;
            this.tmpMaxSimilarity = Math.max(this.tmpMaxSimilarity, similarity);
        }
        if (similarity > this.maxSimilarity || similarity == this.maxSimilarity && numVertex > this.tmpMaxVertex) {
            this.maxSimilarityPathWithSimNumber = cliqueSim;
            logger.debug((Object)("maxSimilarityPathWithSimNumber: " + this.maxSimilarityPathWithSimNumber));
            this.maxSimilarity = similarity;
            this.tmpMaxVertex = Math.max(this.tmpMaxVertex, numVertex);
        }
    }

    public TreeSet<String> getCliqueList() {
        return this.cliqueList;
    }
}

