/*
 * Decompiled with CFR 0.152.
 */
package simpack.measure.graph;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import simpack.accessor.string.StringAccessor;
import simpack.api.IGraphAccessor;
import simpack.api.IGraphNode;
import simpack.api.impl.GraphSimilarityMeasure;
import simpack.measure.sequence.Levenshtein;
import simpack.util.graph.GroupNode;
import simpack.util.graph.MappedVertex;
import simpack.util.graph.comparator.MappedVertexComparator;
import simpack.util.graph.comparator.NamedGraphNodeComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphIsomorphism
extends GraphSimilarityMeasure {
    public static Logger logger = Logger.getLogger(GraphIsomorphism.class);
    public static boolean NODE_GROUPING = false;
    public static String DEFAULT_NODE_LABEL_SIMILARITY_MEASURE = "Levenshtein";
    private boolean groupNodes = NODE_GROUPING;
    private String similarityMeasure = DEFAULT_NODE_LABEL_SIMILARITY_MEASURE;
    private TreeSet<IGraphNode> nodeSet1 = new TreeSet();
    private TreeSet<IGraphNode> nodeSet2 = new TreeSet();
    private IGraphNode node1;
    private IGraphNode node2;
    private TreeMap<String, Integer> groupDegreeMap1 = new TreeMap();
    private TreeMap<String, Integer> groupDegreeMap2 = new TreeMap();
    private TreeMap<MappedVertex, TreeSet<MappedVertex>> adjacentMap = new TreeMap(new MappedVertexComparator());
    private ArrayList<MappedVertex> mappedVertexList = new ArrayList();
    private ArrayList<MappedVertex> startCandidateList = new ArrayList();
    private TreeSet<String> cliqueList = new TreeSet();
    private IGraphAccessor graphAccessor1 = null;
    private IGraphAccessor graphAccessor2 = null;
    private int graphSize = 0;
    private double maxSimilarity = 0.0;
    private String maxSimilarityPathWithSimNumber;
    private long startMillis;
    private int countCliq = 0;
    private int countLoop = 0;
    private int countMV = 0;
    private int countLoopAdjacentMap = 0;
    private Timestamp ts;
    private long millis;
    private Calendar eDate;

    public GraphIsomorphism(IGraphAccessor graphAccessor1, IGraphAccessor graphAccessor2) {
        this(graphAccessor1, graphAccessor2, NODE_GROUPING);
    }

    public GraphIsomorphism(IGraphAccessor graphAccessor1, IGraphAccessor graphAccessor2, boolean groupNodes) {
        this.graphAccessor1 = graphAccessor1;
        this.graphAccessor2 = graphAccessor2;
        this.nodeSet1 = graphAccessor1.getNodeSet();
        this.nodeSet2 = graphAccessor2.getNodeSet();
        this.groupNodes = groupNodes;
    }

    @Override
    public boolean calculate() {
        this.setCalculated(false);
        if (this.getGraphIsomorphism() == 1) {
            this.graphSize = this.nodeSet1.size();
            if (this.groupNodes) {
                this.setGroups(this.graphAccessor1, "G1");
                this.setGroups(this.graphAccessor2, "G2");
            }
            this.mapSameDegree();
            TreeSet<MappedVertex> candidates = new TreeSet<MappedVertex>(new MappedVertexComparator());
            TreeSet<IGraphNode> impossibleLeft = new TreeSet<IGraphNode>(new NamedGraphNodeComparator());
            TreeSet<IGraphNode> impossibleRight = new TreeSet<IGraphNode>(new NamedGraphNodeComparator());
            TreeSet<MappedVertex> clique = new TreeSet<MappedVertex>(new MappedVertexComparator());
            this.adjacentMap = this.getAdjacentMap();
            if (logger.isDebugEnabled()) {
                for (IGraphNode n : this.graphAccessor1.getNodeSet()) {
                    System.out.println("nodeG1: " + n);
                    System.out.println("pre: " + n.getPredecessorSet());
                    System.out.println("suc: " + n.getSuccessorSet());
                }
                for (IGraphNode n : this.graphAccessor2.getNodeSet()) {
                    System.out.println("nodeG2: " + n);
                    System.out.println("pre: " + n.getPredecessorSet());
                    System.out.println("suc: " + n.getSuccessorSet());
                }
                Set<MappedVertex> set = this.adjacentMap.keySet();
                for (MappedVertex mv : set) {
                    System.out.println(mv);
                    if (mv.isGroup()) {
                        System.out.println("grpsiz " + mv.getGroupSize() + "  grpsim " + mv.getGroupSimilarity() + "  Map: " + this.adjacentMap.get(mv));
                    } else {
                        System.out.println("labelsim " + mv.getLabelSimilarity() + "  Map: " + this.adjacentMap.get(mv));
                    }
                    for (MappedVertex n : this.adjacentMap.get(mv)) {
                        System.out.println(n + " sim " + n.getLabelSimilarity());
                    }
                }
            }
            for (MappedVertex m : this.startCandidateList) {
                ++this.countMV;
                if (Math.IEEEremainder(this.countMV, 3.0) == 0.0) {
                    this.eDate = Calendar.getInstance();
                    this.millis = this.eDate.getTime().getTime();
                    this.ts = new Timestamp(this.millis);
                    System.out.println(this.countMV + ") " + m + " " + this.ts + " = " + (this.millis - this.startMillis) / 1000L + " sec");
                }
                candidates.add(m);
                this.nextMaximalClique(candidates, impossibleLeft, impossibleRight, clique);
            }
            this.similarity = this.maxSimilarity;
        } else {
            this.similarity = 0.0;
        }
        this.setCalculated(true);
        return true;
    }

    public int getGraphIsomorphism() {
        if (!this.equalNumberOfVertices()) {
            return 0;
        }
        this.groupDegreeMap1 = this.groupDegree(this.nodeSet1);
        this.groupDegreeMap2 = this.groupDegree(this.nodeSet2);
        while (!this.groupDegreeMap1.isEmpty()) {
            String s = this.groupDegreeMap1.firstKey();
            if (!this.groupDegreeMap2.containsKey(s) || this.groupDegreeMap1.get(s) != this.groupDegreeMap2.get(s)) {
                return 0;
            }
            this.groupDegreeMap1.remove(s);
        }
        return 1;
    }

    public boolean equalNumberOfVertices() {
        return this.nodeSet1.size() == this.nodeSet2.size();
    }

    public TreeMap<String, Integer> groupDegree(TreeSet<IGraphNode> vertexSet) {
        TreeMap<String, Integer> groupDegreeMap = new TreeMap<String, Integer>();
        for (IGraphNode node : vertexSet) {
            String conversion = node.getInDegree().toString() + "," + node.getOutDegree().toString();
            int number = groupDegreeMap.containsKey(conversion) ? groupDegreeMap.get(conversion) + 1 : 1;
            groupDegreeMap.put(conversion, number);
        }
        return groupDegreeMap;
    }

    public void setGroups(IGraphAccessor graphAccessor, String graph) {
        Integer groupCount = 0;
        TreeSet<GroupNode> groupSet = new TreeSet<GroupNode>();
        for (IGraphNode iGraphNode : graphAccessor.getNodeSet()) {
            logger.debug((Object)("node: " + iGraphNode));
            boolean group = true;
            if (iGraphNode.getHasGroup() || iGraphNode.getSuccessorSet() == null || iGraphNode.getSuccessorSet().size() <= 1) continue;
            TreeSet<Object> successorSet = new TreeSet();
            TreeSet<Object> predecessorSet = new TreeSet();
            TreeSet<IGraphNode> memberSet = new TreeSet<IGraphNode>();
            successorSet = iGraphNode.getSuccessorSet();
            IGraphNode firstNode = (IGraphNode)successorSet.first();
            predecessorSet = firstNode.getPredecessorSet();
            logger.debug((Object)("predecessorSet of 1st successor: " + predecessorSet));
            for (IGraphNode iGraphNode2 : successorSet) {
                if ((iGraphNode2.getSuccessorSet() == null || iGraphNode2.getSuccessorSet().size() == 0) && iGraphNode2.getPredecessorSet().size() == predecessorSet.size()) {
                    for (IGraphNode iGraphNode3 : predecessorSet) {
                        if (iGraphNode2.getPredecessorSet().contains(iGraphNode3)) continue;
                        group = false;
                    }
                    continue;
                }
                group = false;
            }
            for (IGraphNode iGraphNode4 : predecessorSet) {
                if (iGraphNode4.getSuccessorSet().size() == successorSet.size()) continue;
                group = false;
            }
            logger.debug((Object)("is groupable: " + group));
            if (!group) continue;
            iGraphNode.setHasGroup();
            Integer i$ = groupCount;
            Integer n = groupCount = Integer.valueOf(groupCount + 1);
            GroupNode g = new GroupNode(graph.concat("_GROUP_").concat(groupCount.toString()));
            groupSet.add(g);
            logger.debug((Object)("groupNode: " + g.toString()));
            g.setGroupSize(successorSet.size());
            for (IGraphNode iGraphNode5 : successorSet) {
                if (iGraphNode5.getIsGroup()) continue;
                memberSet.add(iGraphNode5);
            }
            g.setGroupNodes(memberSet);
            logger.debug((Object)("memberSet: " + memberSet));
            for (IGraphNode iGraphNode6 : predecessorSet) {
                g.addPredecessor(iGraphNode6);
                iGraphNode6.setHasGroup();
                iGraphNode6.addSuccessor(g);
            }
        }
        for (IGraphNode iGraphNode : groupSet) {
            graphAccessor.addNode(iGraphNode);
        }
    }

    public void mapSameDegree() {
        for (IGraphNode node1 : this.nodeSet1) {
            for (IGraphNode node2 : this.nodeSet2) {
                if (node1.getIsGroup() != node2.getIsGroup() || node1.getGroupSize() != node2.getGroupSize() || node1.getInDegree() != node2.getInDegree() || node1.getOutDegree() != node2.getOutDegree()) continue;
                MappedVertex mv = new MappedVertex(node1, node2);
                this.mappedVertexList.add(mv);
                if (node1.getIsGroup()) {
                    if (node1.getGroupSize() > node2.getGroupSize()) {
                        this.groupSimilarity(mv, node2.getGroupNodes(), node1.getGroupNodes(), "reverse");
                        continue;
                    }
                    this.groupSimilarity(mv, node1.getGroupNodes(), node2.getGroupNodes(), "normal");
                    continue;
                }
                if (node1.getInDegree() == 0) {
                    this.startCandidateList.add(mv);
                }
                if (this.similarityMeasure.equals("Levenshtein")) {
                    Levenshtein<String> levenshtein = new Levenshtein<String>(new StringAccessor(((Object)node1).toString()), new StringAccessor(((Object)node2).toString()));
                    mv.setLabelSimilarity(levenshtein.getSimilarity());
                    continue;
                }
                logger.error((Object)"Not yet implemented!");
            }
        }
    }

    public TreeMap<MappedVertex, TreeSet<MappedVertex>> getAdjacentMap() {
        TreeSet<IGraphNode> sourceSet1 = new TreeSet();
        TreeSet<IGraphNode> sourceSet2 = new TreeSet();
        TreeSet<IGraphNode> targetSet1 = new TreeSet();
        TreeSet<IGraphNode> targetSet2 = new TreeSet();
        for (MappedVertex mv : this.mappedVertexList) {
            logger.debug((Object)("mappedVertex: " + mv));
            ++this.countLoopAdjacentMap;
            if (Math.IEEEremainder(this.countLoopAdjacentMap, 1000.0) == 0.0) {
                System.out.println("loop adjacency: " + this.countLoopAdjacentMap + " mv: " + mv);
            }
            TreeSet<MappedVertex> commonAdjacentSet = new TreeSet<MappedVertex>(new MappedVertexComparator());
            IGraphNode node1 = mv.getLeftNode();
            IGraphNode node2 = mv.getRightNode();
            sourceSet1 = node1.getPredecessorSet();
            sourceSet2 = node2.getPredecessorSet();
            targetSet1 = node1.getSuccessorSet();
            targetSet2 = node2.getSuccessorSet();
            if (logger.isDebugEnabled()) {
                System.out.println("nodes: " + node1 + ", " + node2);
                System.out.println("sourceSet1: " + sourceSet1);
                System.out.println("sourceSet2: " + sourceSet2);
                System.out.println("targetSet1: " + targetSet1);
                System.out.println("targetSet2: " + targetSet2);
            }
            if (sourceSet1 != null && sourceSet2 != null) {
                commonAdjacentSet = this.adjacentNodes(commonAdjacentSet, sourceSet1, sourceSet2);
            }
            if (targetSet1 != null && targetSet2 != null) {
                if (node1.getHasGroup() && node2.getHasGroup()) {
                    logger.debug((Object)"have group!");
                    commonAdjacentSet = this.adjacentGroups(commonAdjacentSet, targetSet1, targetSet2);
                } else {
                    commonAdjacentSet = this.adjacentNodes(commonAdjacentSet, targetSet1, targetSet2);
                }
            }
            logger.debug((Object)("commonAdjacentSet: " + commonAdjacentSet));
            this.adjacentMap.put(mv, commonAdjacentSet);
            if (!logger.isDebugEnabled()) continue;
            for (MappedVertex m : commonAdjacentSet) {
                System.out.println("MV: " + mv + " " + mv.isGroup() + " m: " + m + " " + m.isGroup());
            }
        }
        return this.adjacentMap;
    }

    public TreeSet<MappedVertex> adjacentNodes(TreeSet<MappedVertex> commonAdjacentSet, TreeSet<IGraphNode> adjacentSet1, TreeSet<IGraphNode> adjacentSet2) {
        for (IGraphNode node1 : adjacentSet1) {
            for (IGraphNode node2 : adjacentSet2) {
                if (node1.getIsGroup() || node2.getIsGroup()) continue;
                MappedVertex mv = new MappedVertex(node1, node2);
                for (MappedVertex m : this.mappedVertexList) {
                    if (!mv.equals(m)) continue;
                    commonAdjacentSet.add(m);
                }
                if (!logger.isDebugEnabled()) continue;
                System.out.println("mappedVertex: " + mv);
                System.out.println("equal similarity: " + ((Object)node1).toString().equals(((Object)node2).toString()));
            }
        }
        return commonAdjacentSet;
    }

    public TreeSet<MappedVertex> adjacentGroups(TreeSet<MappedVertex> commonAdjacentSet, TreeSet<IGraphNode> adjacentSet1, TreeSet<IGraphNode> adjacentSet2) {
        for (IGraphNode node1 : adjacentSet1) {
            for (IGraphNode node2 : adjacentSet2) {
                if (!node1.getIsGroup() || !node2.getIsGroup()) continue;
                MappedVertex mv = new MappedVertex(node1, node2);
                for (MappedVertex m : this.mappedVertexList) {
                    if (!mv.equals(m)) continue;
                    commonAdjacentSet.add(m);
                }
                if (!logger.isDebugEnabled()) continue;
                System.out.println("mappedVertex: " + mv + " " + mv.isGroup());
                System.out.println("size: " + mv.getGroupSize());
            }
        }
        return commonAdjacentSet;
    }

    public void groupSimilarity(MappedVertex mv, TreeSet<IGraphNode> groupSmall, TreeSet<IGraphNode> groupLarge, String order) {
        ArrayList currentNodes;
        ArrayList currentSim;
        HashMap<IGraphNode, ArrayList> nodeMapping = new HashMap<IGraphNode, ArrayList>();
        HashMap<IGraphNode, ArrayList> simMapping = new HashMap<IGraphNode, ArrayList>();
        ArrayList<MappedVertex> groupMembers = new ArrayList<MappedVertex>();
        Double groupSim = 0.0;
        int ind = 0;
        for (IGraphNode n1 : groupSmall) {
            currentSim = new ArrayList();
            currentNodes = new ArrayList();
            for (IGraphNode n2 : groupLarge) {
                if (this.similarityMeasure.equals("Levenshtein")) {
                    Levenshtein<String> levenshtein = new Levenshtein<String>(new StringAccessor(((Object)n1).toString()), new StringAccessor(((Object)n2).toString()));
                    currentSim.add(levenshtein.getSimilarity());
                    currentNodes.add(n2);
                    continue;
                }
                logger.error((Object)"Not yet implemented!");
            }
            nodeMapping.put(n1, currentNodes);
            simMapping.put(n1, currentSim);
        }
        for (IGraphNode n1 : groupSmall) {
            currentSim = new ArrayList();
            currentNodes = new ArrayList();
            currentSim = (ArrayList)simMapping.get(n1);
            currentNodes = (ArrayList)nodeMapping.get(n1);
            Double tmpMax = 0.0;
            for (Double d : currentSim) {
                tmpMax = Math.max(tmpMax, d);
            }
            ind = currentSim.indexOf(tmpMax);
            groupSim = groupSim + tmpMax;
            IGraphNode n2 = (IGraphNode)currentNodes.get(ind);
            MappedVertex groupMem = order.equals("normal") ? new MappedVertex(n1, n2) : new MappedVertex(n2, n1);
            groupMembers.add(groupMem);
            for (IGraphNode n : groupSmall) {
                ((ArrayList)simMapping.get(n)).remove(ind);
                ((ArrayList)nodeMapping.get(n)).remove(ind);
            }
        }
        for (MappedVertex m : groupMembers) {
            mv.addGroupMember(m);
        }
        mv.setGroupSimilarity(groupSim);
        mv.setGroupSize(Math.min(groupSmall.size(), groupLarge.size()));
        if (logger.isDebugEnabled()) {
            System.out.println("MappedVertex: " + mv);
            System.out.println("groupMembers: " + groupMembers);
            System.out.println("groupSimilarity: " + groupSim);
        }
    }

    public void nextMaximalClique(TreeSet<MappedVertex> candidates, TreeSet<IGraphNode> impossibleLeft, TreeSet<IGraphNode> impossibleRight, TreeSet<MappedVertex> clique) {
        block16: {
            block15: {
                TreeSet<MappedVertex> clique2 = new TreeSet<MappedVertex>(new MappedVertexComparator());
                int cliqueSize = 0;
                ++this.countLoop;
                if (Math.IEEEremainder(this.countLoop, 100000.0) == 0.0) {
                    System.out.println("countLoop: " + this.countLoop);
                }
                for (MappedVertex copy : clique) {
                    clique2.add(copy);
                }
                if (!candidates.isEmpty()) break block15;
                for (MappedVertex mv : clique2) {
                    if (mv.isGroup()) {
                        cliqueSize += mv.getGroupSize();
                        logger.debug((Object)(mv.isGroup() + " group size: " + mv.getGroupSize()));
                        continue;
                    }
                    ++cliqueSize;
                }
                logger.debug((Object)("cliq size: " + cliqueSize + " " + this.graphSize));
                if (cliqueSize != this.graphSize) break block16;
                this.checkIfMaxClique(clique2);
                logger.debug((Object)"max cliq!!!!!!!!!!!!!!");
                ++this.countCliq;
                if (Math.IEEEremainder(this.countCliq, 50000.0) != 0.0) break block16;
                System.out.println("Cliq: " + this.countCliq + " " + clique2);
                break block16;
            }
            while (!candidates.isEmpty()) {
                MappedVertex v = candidates.first();
                candidates.remove(v);
                this.node1 = v.getLeftNode();
                this.node2 = v.getRightNode();
                TreeSet<MappedVertex> tempCandidates = new TreeSet<MappedVertex>(new MappedVertexComparator());
                TreeSet<IGraphNode> tempImpossibleLeft = new TreeSet<IGraphNode>(new NamedGraphNodeComparator());
                TreeSet<IGraphNode> tempImpossibleRight = new TreeSet<IGraphNode>(new NamedGraphNodeComparator());
                if (logger.isDebugEnabled()) {
                    System.out.println("mappedVertex: " + v);
                    System.out.println("impossible before l: " + impossibleLeft);
                    System.out.println("impossible before r: " + impossibleRight);
                    System.out.println("adjacent for mappedVertex: " + this.adjacentMap.get(v));
                }
                for (MappedVertex w : this.adjacentMap.get(v)) {
                    if (!(impossibleLeft.contains(w.getLeftNode()) || impossibleRight.contains(w.getRightNode()) || clique.contains(w))) {
                        tempCandidates.add(w);
                        continue;
                    }
                    if (!logger.isDebugEnabled()) continue;
                    System.out.println("new candidate not added: " + w);
                    System.out.println(!impossibleLeft.contains(this.node1) + " " + !impossibleRight.contains(this.node2) + " " + !clique.contains(w));
                }
                logger.debug((Object)("only new candidates: " + tempCandidates));
                for (MappedVertex w : candidates) {
                    if (logger.isDebugEnabled()) {
                        System.out.println("old candidate: " + w);
                        System.out.println(this.adjacentMap.get(v).contains(w) + " " + !w.getLeftNode().equals(this.node1) + " " + !w.getRightNode().equals(this.node2) + " " + !this.node1.getAdjacentSet().contains(w.getLeftNode()) + " " + !this.node2.getAdjacentSet().contains(w.getRightNode()));
                    }
                    if (!this.adjacentMap.get(v).contains(w) && (w.getLeftNode().equals(this.node1) || w.getRightNode().equals(this.node2) || this.node1.getAdjacentSet().contains(w.getLeftNode()) || this.node2.getAdjacentSet().contains(w.getRightNode()))) continue;
                    tempCandidates.add(w);
                }
                for (IGraphNode node : impossibleLeft) {
                    tempImpossibleLeft.add(node);
                }
                for (IGraphNode node : impossibleRight) {
                    tempImpossibleRight.add(node);
                }
                for (IGraphNode node : this.node1.getAdjacentSet()) {
                    tempImpossibleLeft.add(node);
                }
                for (IGraphNode node : this.node2.getAdjacentSet()) {
                    tempImpossibleRight.add(node);
                }
                tempImpossibleLeft.add(this.node1);
                tempImpossibleRight.add(this.node2);
                clique.add(v);
                if (logger.isDebugEnabled()) {
                    System.out.println("clique: " + clique);
                    System.out.println("all candidates: " + tempCandidates);
                    System.out.println("impossible after l: " + tempImpossibleLeft);
                    System.out.println("impossible after r: " + tempImpossibleRight);
                }
                this.nextMaximalClique(tempCandidates, tempImpossibleLeft, tempImpossibleRight, clique);
                clique.remove(v);
            }
        }
    }

    public void checkIfMaxClique(TreeSet<MappedVertex> clique) {
        int groupVertexSize = 0;
        double labelSimilarity = 0.0;
        String pathWithSimNumber = "";
        logger.debug((Object)("clique: " + clique));
        for (MappedVertex m : clique) {
            logger.debug((Object)(m + " isgroup: " + m.isGroup()));
            if (m.isGroup()) {
                logger.debug((Object)(" groupsiz: " + m.getGroupSize() + " groupsim: " + m.getGroupSimilarity()));
                labelSimilarity += m.getGroupSimilarity();
                groupVertexSize = groupVertexSize + m.getGroupSize() - 1;
                for (MappedVertex mv : m.getGroupMembers()) {
                    if (pathWithSimNumber.equals("")) {
                        pathWithSimNumber = pathWithSimNumber + mv.toString();
                        continue;
                    }
                    pathWithSimNumber = pathWithSimNumber + ", " + mv.toString();
                }
            } else {
                logger.debug((Object)("labelsim: " + m.getLabelSimilarity()));
                labelSimilarity += m.getLabelSimilarity();
                pathWithSimNumber = pathWithSimNumber.equals("") ? pathWithSimNumber + m.toString() : pathWithSimNumber + ", " + m.toString();
            }
            logger.debug((Object)("totalSimilarity: " + labelSimilarity));
        }
        logger.debug((Object)("labelSimilarity absolute: " + labelSimilarity));
        labelSimilarity /= (double)(clique.size() + groupVertexSize);
        if (logger.isDebugEnabled()) {
            System.out.println("clique: " + pathWithSimNumber);
            System.out.println("labelSimilarity: " + labelSimilarity);
        }
        String path = pathWithSimNumber;
        if (labelSimilarity == 1.0) {
            pathWithSimNumber = pathWithSimNumber + "; 1";
        } else {
            int tempInt = (int)(labelSimilarity * 100.0);
            Integer conversion = new Integer(tempInt);
            pathWithSimNumber = pathWithSimNumber + "; 0." + conversion.toString();
        }
        this.checkMax(labelSimilarity, path, pathWithSimNumber);
    }

    public void checkMax(double similarity, String clique, String cliqueSim) {
        if (similarity >= this.maxSimilarity) {
            if (similarity > this.maxSimilarity) {
                this.cliqueList.clear();
            }
            this.cliqueList.add(clique);
        }
        if (similarity > this.maxSimilarity) {
            this.maxSimilarityPathWithSimNumber = cliqueSim;
            logger.debug((Object)("maxSimilarityPathWithSimNumber: " + this.maxSimilarityPathWithSimNumber));
        }
        this.maxSimilarity = Math.max(this.maxSimilarity, similarity);
    }

    public TreeSet<String> getCliqueList() {
        return this.cliqueList;
    }
}

