/*
 * Decompiled with CFR 0.152.
 */
package simpack.measure.graph;

import org.apache.log4j.Logger;
import simpack.api.IGraphAccessor;
import simpack.api.IGraphNode;
import simpack.api.impl.SimilarityMeasure;
import simpack.exception.InvalidElementException;

public class ConceptualSimilarity
extends SimilarityMeasure {
    static Logger logger = Logger.getLogger(ConceptualSimilarity.class);
    private double N1;
    private double N2;
    private double N3;
    private IGraphAccessor graphAccessor;
    private IGraphNode nodeN1;
    private IGraphNode nodeN2;

    public ConceptualSimilarity(double N1, double N2, double N3) {
        this.N1 = N1;
        this.N2 = N2;
        this.N3 = N3;
    }

    public ConceptualSimilarity(IGraphAccessor accessor, IGraphNode nodeN1, IGraphNode nodeN2) throws InvalidElementException {
        this.graphAccessor = accessor;
        this.nodeN1 = nodeN1;
        this.nodeN2 = nodeN2;
        if (!accessor.contains(nodeN1)) {
            throw new InvalidElementException(((Object)nodeN1).toString() + " not in graph");
        }
        if (!accessor.contains(nodeN2)) {
            throw new InvalidElementException(((Object)nodeN2).toString() + " not in graph");
        }
    }

    public boolean calculate() {
        this.setCalculated(false);
        if (this.nodeN1 != null) {
            IGraphNode mrca = null;
            try {
                mrca = this.graphAccessor.getMostRecentCommonAncestor(this.nodeN1, this.nodeN2);
                IGraphNode root = this.graphAccessor.getRoot();
                this.N3 = this.graphAccessor.getShortestPath(mrca, root);
                double N1N2 = this.graphAccessor.getShortestPath(this.nodeN1, this.nodeN2);
                this.similarity = this.N3 == 0.0 ? new Double(1.0 / (N1N2 + 1.0)) : new Double(2.0 * this.N3 / (N1N2 + 2.0 * this.N3));
                this.setCalculated(true);
                return true;
            }
            catch (InvalidElementException e) {
                e.printStackTrace();
                return false;
            }
        }
        this.similarity = new Double(2.0 * this.N3 / (this.N1 + this.N2 + 2.0 * this.N3));
        this.setCalculated(true);
        return true;
    }
}

