/*
 * Decompiled with CFR 0.152.
 */
package simpack.api.impl;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import simpack.api.ITreeAccessor;
import simpack.api.ITreeNode;
import simpack.api.ITreeSequenceAccessor;
import simpack.exception.InvalidElementException;
import simpack.util.tree.comparator.NamedTreeNodeComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTreeAccessor
implements ITreeAccessor,
ITreeSequenceAccessor {
    protected ITreeNode tree;

    @Override
    public ITreeNode getRoot() {
        return this.tree;
    }

    @Override
    public List<Object> getPreorderSequence() {
        ArrayList<Object> preorderSequenceOfTree = new ArrayList<Object>();
        this.preorder(this.getRoot(), preorderSequenceOfTree);
        return preorderSequenceOfTree;
    }

    @Override
    public List<Object> getPostorderSequence() {
        ArrayList<Object> postorderSequenceOfTree = new ArrayList<Object>();
        this.postorder(this.getRoot(), postorderSequenceOfTree);
        return postorderSequenceOfTree;
    }

    public List<Object> getSequence() {
        return this.getPreorderSequence();
    }

    @Override
    public ITreeNode getMostRecentCommonAncestor(ITreeNode node1, ITreeNode node2) throws InvalidElementException {
        DefaultMutableTreeNode n1 = null;
        DefaultMutableTreeNode n2 = null;
        n1 = this.getNode(node1);
        n2 = this.getNode(node2);
        if (n1 == null) {
            throw new InvalidElementException("Node " + node1.toString() + " is invalid");
        }
        if (n2 == null) {
            throw new InvalidElementException("Node " + node2.toString() + " is invalid");
        }
        return (simpack.util.tree.TreeNode)n1.getSharedAncestor(n2);
    }

    @Override
    public Set<ITreeNode> getDescendants(ITreeNode node) throws InvalidElementException {
        TreeSet<ITreeNode> descendants = new TreeSet<ITreeNode>(new NamedTreeNodeComparator());
        DefaultMutableTreeNode n = this.getNode(node);
        if (n != null) {
            Enumeration<TreeNode> en = n.preorderEnumeration();
            en.nextElement();
            while (en.hasMoreElements()) {
                descendants.add(new simpack.util.tree.TreeNode(((DefaultMutableTreeNode)en.nextElement()).toString()));
            }
            return descendants;
        }
        throw new InvalidElementException("Node " + node.toString() + " is invalid");
    }

    @Override
    public Set<ITreeNode> getAncestors(ITreeNode node) throws InvalidElementException {
        TreeSet<ITreeNode> ancestors = new TreeSet<ITreeNode>(new NamedTreeNodeComparator());
        DefaultMutableTreeNode n = this.getNode(node);
        if (n != null) {
            Enumeration<TreeNode> en = n.pathFromAncestorEnumeration(this.getRoot());
            while (en.hasMoreElements()) {
                ancestors.add(new simpack.util.tree.TreeNode(((DefaultMutableTreeNode)en.nextElement()).toString()));
            }
            ancestors.remove(node);
            return ancestors;
        }
        throw new InvalidElementException("Node " + node.toString() + " is invalid");
    }

    @Override
    public Set<ITreeNode> getChildren(ITreeNode node) throws InvalidElementException {
        TreeSet<ITreeNode> children = new TreeSet<ITreeNode>(new NamedTreeNodeComparator());
        DefaultMutableTreeNode n = this.getNode(node);
        if (n != null) {
            Enumeration<TreeNode> en = n.children();
            while (en.hasMoreElements()) {
                children.add(new simpack.util.tree.TreeNode(((DefaultMutableTreeNode)en.nextElement()).toString()));
            }
            return children;
        }
        throw new InvalidElementException("Node " + node.toString() + " is invalid");
    }

    @Override
    public Set<ITreeNode> getParents(ITreeNode node) throws InvalidElementException {
        TreeSet<ITreeNode> parents = new TreeSet<ITreeNode>(new NamedTreeNodeComparator());
        DefaultMutableTreeNode n = this.getNode(node);
        if (n != null) {
            parents.add(new simpack.util.tree.TreeNode(n.getParent().toString()));
            return parents;
        }
        throw new InvalidElementException("Node " + node.toString() + " is invalid");
    }

    @Override
    public boolean contains(ITreeNode node) {
        DefaultMutableTreeNode n = this.getNode(node);
        if (n == null) {
            return false;
        }
        return ((simpack.util.tree.TreeNode)this.tree).isNodeDescendant(n);
    }

    @Override
    public int size() {
        int size = 0;
        Enumeration<TreeNode> en = ((simpack.util.tree.TreeNode)this.tree).breadthFirstEnumeration();
        while (en.hasMoreElements()) {
            en.nextElement();
            ++size;
        }
        return size;
    }

    private final DefaultMutableTreeNode getNode(ITreeNode node) {
        Enumeration<TreeNode> en = ((simpack.util.tree.TreeNode)this.tree).preorderEnumeration();
        while (en.hasMoreElements()) {
            DefaultMutableTreeNode o = (DefaultMutableTreeNode)en.nextElement();
            if (!o.toString().equals(node.getUserObject().toString())) continue;
            return o;
        }
        return null;
    }

    private final void preorder(ITreeNode node, ArrayList<Object> preorderSequenceOfTree) {
        if (node != null) {
            preorderSequenceOfTree.add(node);
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                ITreeNode child = (ITreeNode)e.nextElement();
                this.preorder(child, preorderSequenceOfTree);
            }
        } else {
            return;
        }
    }

    private final void postorder(ITreeNode node, ArrayList<Object> postorderSequenceOfTree) {
        if (node != null) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                ITreeNode child = (ITreeNode)e.nextElement();
                this.postorder(child, postorderSequenceOfTree);
            }
        } else {
            return;
        }
        postorderSequenceOfTree.add(node);
    }
}

