/*
 * Decompiled with CFR 0.152.
 */
package simpack.api.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import simpack.api.IToken;
import simpack.api.ITokenizer;
import simpack.tokenizer.tokens.BasicToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTokenizer
implements ITokenizer {
    private Map<String, IToken> fTokenMap = new TreeMap<String, IToken>();
    private int fNextIndex = 0;

    @Override
    public List<IToken> tokenize(String s) {
        String[] stringTokens;
        ArrayList<IToken> resultTokens = new ArrayList<IToken>();
        for (String stringToken : stringTokens = this.buildStringTokens(s)) {
            IToken token = this.intern(stringToken);
            resultTokens.add(token);
        }
        return resultTokens;
    }

    protected abstract String[] buildStringTokens(String var1);

    protected IToken intern(String s) {
        IToken token = this.fTokenMap.get(s);
        if (token == null) {
            token = new BasicToken(++this.fNextIndex, s);
            this.fTokenMap.put(s, token);
        }
        return token;
    }

    public void clear() {
        this.fTokenMap.clear();
    }
}

