/*
 * Decompiled with CFR 0.152.
 */
package simpack.api.impl;

import java.util.TreeSet;
import simpack.api.IGraphAccessor;
import simpack.api.IGraphNode;
import simpack.util.graph.comparator.NamedGraphNodeComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGraphAccessor
implements IGraphAccessor {
    protected TreeSet<IGraphNode> nodeSet = new TreeSet<IGraphNode>(new NamedGraphNodeComparator());
    protected IGraphNode root;

    @Override
    public int size() {
        return this.nodeSet.size();
    }

    @Override
    public TreeSet<IGraphNode> getNodeSet() {
        return this.nodeSet;
    }

    @Override
    public IGraphNode getNode(String label) {
        for (IGraphNode node : this.nodeSet) {
            if (!node.getLabel().equals(label)) continue;
            return node;
        }
        return null;
    }

    @Override
    public void addNode(IGraphNode node) {
        this.nodeSet.add(node);
    }

    @Override
    public boolean contains(IGraphNode node) {
        for (IGraphNode n : this.nodeSet) {
            if (!n.equals(node)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IGraphNode getRoot() {
        if (this.root == null) {
            for (IGraphNode node : this.nodeSet) {
                if (node.getPredecessorSet().size() != 0) continue;
                this.root = node;
            }
        }
        return this.root;
    }

    @Override
    public void setEdge(IGraphNode tmpSourceNode, IGraphNode tmpTargetNode) {
        IGraphNode sourceNode = null;
        if (this.contains(tmpSourceNode)) {
            sourceNode = this.getNode(tmpSourceNode.getLabel());
        } else {
            sourceNode = tmpSourceNode;
            this.addNode(sourceNode);
        }
        IGraphNode targetNode = null;
        if (this.contains(tmpTargetNode)) {
            targetNode = this.getNode(tmpTargetNode.getLabel());
        } else {
            targetNode = tmpTargetNode;
            this.addNode(targetNode);
        }
        sourceNode.addSuccessor(targetNode);
        targetNode.addPredecessor(sourceNode);
    }
}

