/*
 * Decompiled with CFR 0.152.
 */
package simpack.accessor.string;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import simpack.api.ISequenceAccessor;
import simpack.api.IToken;
import simpack.api.ITokenizer;
import simpack.api.impl.CollectionAccessor;
import simpack.tokenizer.DummyTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringAccessor
extends CollectionAccessor<String>
implements ISequenceAccessor<String> {
    private String s;

    public StringAccessor(String s) {
        this(s, new DummyTokenizer());
    }

    public StringAccessor(String s, ITokenizer tokenizer) {
        this.s = s;
        this.elements = new Vector();
        List<IToken> tokens = tokenizer.tokenize(s);
        for (IToken token : tokens) {
            this.elements.add(token.getValue());
        }
    }

    public int length() {
        return this.getSize();
    }

    public String unwrap() {
        return this.s;
    }

    public char charAt(int i) {
        return this.s.charAt(i);
    }

    public String getTokenAt(int i) {
        return this.elements.toArray(new String[0])[i];
    }

    @Override
    public int getElementFrequency(String s) {
        int f = 0;
        String[] strings = this.elements.toArray(new String[0]);
        for (int i = 0; i < strings.length; ++i) {
            if (!strings[i].equals(s)) continue;
            ++f;
        }
        return f;
    }

    @Override
    public int[] getElementFrequencies() {
        String[] strings = this.elements.toArray(new String[0]);
        int[] frequencies = new int[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            frequencies[i] = this.getElementFrequency(strings[i]);
        }
        return frequencies;
    }

    @Override
    public List<String> getSequence() {
        return new ArrayList<String>(this.elements);
    }

    @Override
    public String toString() {
        return this.unwrap();
    }
}

