/*
 * Decompiled with CFR 0.152.
 */
package simpack.accessor.sequence;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import simpack.api.ISequenceAccessor;
import simpack.api.impl.CollectionAccessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SplittedStringAccessor
extends CollectionAccessor<String>
implements ISequenceAccessor<String> {
    public SplittedStringAccessor(String str, String patternStr) {
        this.elements = new ArrayList();
        String[] strings = str.split(patternStr);
        for (int i = 0; i < strings.length; ++i) {
            this.elements.add(strings[i]);
        }
    }

    @Override
    public int getElementFrequency(String s) {
        int f = 0;
        String[] strings = this.elements.toArray(new String[0]);
        for (int i = 0; i < strings.length; ++i) {
            if (!strings[i].equals(s)) continue;
            ++f;
        }
        return f;
    }

    @Override
    public int[] getElementFrequencies() {
        String[] strings = this.elements.toArray(new String[0]);
        int[] frequencies = new int[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            frequencies[i] = this.getElementFrequency(strings[i]);
        }
        return frequencies;
    }

    @Override
    public List<String> getSequence() {
        Vector<String> sequence = new Vector<String>();
        for (String str : this.elements) {
            sequence.add(str);
        }
        return sequence;
    }
}

