/*
 * Decompiled with CFR 0.152.
 */
package simpack.accessor.list;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.PriorityQueue;
import simpack.api.impl.CollectionAccessor;
import simpack.exception.InvalidElementException;
import simpack.measure.weightingscheme.AbstractTFIDF;
import simpack.util.Vector;
import simpack.util.corpus.Indexer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneIndexAccessor<E>
extends CollectionAccessor<E> {
    public static Logger logger = Logger.getLogger(LuceneIndexAccessor.class);
    public static Analyzer analyzer = Indexer.DEFAULT_ANALYZER;
    private String[] fieldNames = Indexer.DEFAULT_FIELD_NAMES;
    private String index;
    private IndexReader ir;
    private IndexSearcher is;

    public LuceneIndexAccessor(String index) throws IOException {
        this.index = index;
        this.createReader();
        this.createSearcher();
    }

    public IndexReader getIndexReader() {
        return this.ir;
    }

    public IndexSearcher getIndexSearcher() {
        return this.is;
    }

    @Override
    public int getSize() {
        return this.ir.numDocs();
    }

    @Override
    public boolean containsElement(E object) {
        try {
            QueryParser qp = new QueryParser("title", analyzer);
            Hits hits = this.is.search(qp.parse((String)object));
            int hitCount = hits.length();
            return hitCount > 0;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public Vector<Double> getWeights(E object) throws InvalidElementException {
        try {
            Vector<Double> weights = new Vector<Double>();
            int docID = this.getDocID((String)object);
            if (docID == -1) {
                throw new InvalidElementException("Document '" + (String)object + "' not in index.");
            }
            double max = this.getMaxTF(this.getTermFrequencies(docID));
            TermEnum te = this.ir.terms();
            while (te.next()) {
                Term currentTerm = te.term();
                double tf = 0.0;
                if (!currentTerm.field().equals("contents")) continue;
                double idf = AbstractTFIDF.idf2(this.ir.numDocs(), te.docFreq());
                TermDocs td = this.ir.termDocs(currentTerm);
                if (td.skipTo(docID)) {
                    tf = AbstractTFIDF.tfSaltonBuckley(td.freq(), max);
                    weights.add(tf * idf);
                    continue;
                }
                weights.add(0.0);
            }
            return weights;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public PriorityQueue retrieveTerms(int docNum) throws IOException {
        Map<String, Int> termFreqMap = this.getTermFrequencies(docNum);
        return this.createQueue(termFreqMap);
    }

    private Map<String, Int> getTermFrequencies(int docNum) throws IOException {
        HashMap<String, Int> termFreqMap = new HashMap<String, Int>();
        String fieldName = "contents";
        TermFreqVector vector = this.ir.getTermFreqVector(docNum, fieldName);
        if (vector == null) {
            Document d = this.ir.document(docNum);
            String[] text = d.getValues(fieldName);
            if (text != null) {
                for (int j = 0; j < text.length; ++j) {
                    this.addTermFrequencies(new StringReader(text[j]), termFreqMap, fieldName);
                }
            }
        } else {
            this.addTermFrequencies(termFreqMap, vector);
        }
        return termFreqMap;
    }

    private void createReader() throws IOException {
        FSDirectory fsDir = FSDirectory.getDirectory((String)this.index, (boolean)false);
        this.ir = IndexReader.open((Directory)fsDir);
    }

    private void createSearcher() throws IOException {
        FSDirectory fsDir = FSDirectory.getDirectory((String)this.index, (boolean)false);
        this.is = new IndexSearcher((Directory)fsDir);
    }

    private int getDocID(String docName) throws Exception {
        QueryParser qp = new QueryParser("title", analyzer);
        Hits hits = this.is.search(qp.parse(docName));
        if (hits.length() == 1) {
            return hits.id(0);
        }
        return -1;
    }

    private double getMaxTF(Map words) {
        double max = 0.0;
        for (String word : words.keySet()) {
            int tf = ((Int)words.get((Object)word)).x;
            if (!((double)tf > max)) continue;
            max = tf;
        }
        return max;
    }

    private double getNormalization(Map words) throws IOException {
        int numDocs = this.ir.numDocs();
        double denominator = 0.0;
        for (String word : words.keySet()) {
            int tf = ((Int)words.get((Object)word)).x;
            int docFreq = 0;
            int freq = this.ir.docFreq(new Term("contents", word));
            int n = docFreq = freq > docFreq ? freq : docFreq;
            if (docFreq == 0) continue;
            double idf = AbstractTFIDF.idf2(docFreq, numDocs);
            denominator += (double)(tf * tf) * (idf * idf);
        }
        return Math.sqrt(denominator);
    }

    private PriorityQueue createQueue(Map words) throws IOException {
        int numDocs = this.ir.numDocs();
        FreqQ res = new FreqQ(words.size());
        double max = this.getMaxTF(words);
        for (String word : words.keySet()) {
            double tf = ((Int)words.get((Object)word)).x;
            tf = AbstractTFIDF.tfSaltonBuckley(tf, max);
            String topField = this.fieldNames[0];
            int docFreq = 0;
            int freq = this.ir.docFreq(new Term("contents", word));
            topField = "contents";
            int n = docFreq = freq > docFreq ? freq : docFreq;
            if (docFreq == 0) continue;
            double idf = AbstractTFIDF.idf2(numDocs, docFreq);
            double score = tf * idf;
            res.insert(new Object[]{word, topField, new Double(score), new Double(idf), new Integer(docFreq), new Double(tf), new Double(0.0)});
        }
        return res;
    }

    private void addTermFrequencies(Reader r, Map<String, Int> termFreqMap, String fieldName) throws IOException {
        Token token;
        TokenStream ts = Indexer.DEFAULT_ANALYZER.tokenStream(fieldName, r);
        while ((token = ts.next()) != null) {
            String word = token.termText();
            Int cnt = termFreqMap.get(word);
            if (cnt == null) {
                termFreqMap.put(word, new Int());
                continue;
            }
            ++cnt.x;
        }
    }

    private void addTermFrequencies(Map<String, Int> termFreqMap, TermFreqVector vector) {
        String[] terms = vector.getTerms();
        int[] freqs = vector.getTermFrequencies();
        for (int j = 0; j < terms.length; ++j) {
            String term = terms[j];
            Int cnt = termFreqMap.get(term);
            if (cnt == null) {
                cnt = new Int();
                cnt.x = freqs[j];
                termFreqMap.put(term, cnt);
                continue;
            }
            cnt.x += freqs[j];
        }
    }

    private static class FreqQ
    extends PriorityQueue {
        FreqQ(int s) {
            this.initialize(s);
        }

        protected boolean lessThan(Object a, Object b) {
            Object[] aa = (Object[])a;
            Object[] bb = (Object[])b;
            Double fa = (Double)aa[2];
            Double fb = (Double)bb[2];
            return fa > fb;
        }
    }

    private static class Int {
        int x = 1;

        Int() {
        }
    }
}

