/*
 * Decompiled with CFR 0.152.
 */
package simpack.accessor.list;

import java.util.ArrayList;
import java.util.List;
import simpack.api.impl.CollectionAccessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonListAccessor<E>
extends CollectionAccessor<E> {
    private ArrayList<E> elements;

    public CommonListAccessor() {
        this(new ArrayList());
    }

    public CommonListAccessor(ArrayList<E> elements) {
        this.elements = elements;
    }

    public int getNumberOfOccurrence(E object) {
        int ret = 0;
        for (E o : this.elements) {
            if (!o.equals(object)) continue;
            ++ret;
        }
        return ret;
    }

    public List<E> getElements(E object) {
        if (this.containsElement(object)) {
            ArrayList<E> result = new ArrayList<E>();
            for (E o : this.elements) {
                if (!o.equals(object)) continue;
                result.add(o);
            }
            return result;
        }
        return null;
    }

    public List<E> getElementsBefore(E object) {
        if (this.containsElement(object)) {
            ArrayList<E> result = new ArrayList<E>();
            int index = this.elements.indexOf(object);
            for (int i = 0; i < index; ++i) {
                result.add(this.elements.get(i));
            }
            return result;
        }
        return null;
    }

    public List<E> getElementsAfter(E object) {
        if (this.containsElement(object)) {
            ArrayList<E> result = new ArrayList<E>();
            int index = this.elements.indexOf(object);
            int size = this.getSize();
            for (int i = index + 1; i < size; ++i) {
                result.add(this.elements.get(i));
            }
            return result;
        }
        return null;
    }
}

