/*
 * Decompiled with CFR 0.152.
 */
package simpack.accessor.graph;

import ch.unibern.graphmatching2.Graph;
import ch.unibern.graphmatching2.Vertex;
import java.io.InputStream;
import java.net.URL;
import java.util.Set;
import org.apache.log4j.Logger;
import org.embl.ebi.escience.scufl.DataConstraint;
import org.embl.ebi.escience.scufl.InputPort;
import org.embl.ebi.escience.scufl.OutputPort;
import org.embl.ebi.escience.scufl.Processor;
import org.embl.ebi.escience.scufl.ScuflModel;
import org.embl.ebi.escience.scufl.parser.XScuflParser;
import simpack.api.IGraphNode;
import simpack.api.impl.AbstractGraphAccessor;
import simpack.util.graph.GraphNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScufleXMLGraphAccessor
extends AbstractGraphAccessor {
    public static Logger logger = Logger.getLogger(ScufleXMLGraphAccessor.class);

    public ScufleXMLGraphAccessor(String filename) {
        this.BuildServiceGraph(filename);
    }

    public ScuflModel loadScufl(String WorkflowLocation) {
        ScuflModel mymodel = new ScuflModel();
        mymodel.setEventStatus(false);
        try {
            mymodel.setOffline(true);
            URL location = new URL(WorkflowLocation);
            logger.debug((Object)("Loading definition from : " + location.toString()));
            XScuflParser.populate((InputStream)location.openStream(), (ScuflModel)mymodel, null);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return mymodel;
    }

    public Graph BuildServiceGraph(String WorkflowLocation) {
        Graph graphmodel = new Graph();
        try {
            int node;
            ScuflModel model = this.loadScufl(WorkflowLocation);
            logger.debug((Object)"\nNodes\n");
            Processor[] myprocessors = model.getProcessors();
            Processor mysource = model.getWorkflowSourceProcessor();
            OutputPort[] mysourceports = mysource.getOutputPorts();
            Processor mysink = model.getWorkflowSinkProcessor();
            InputPort[] mysinkports = mysink.getInputPorts();
            int graphsize = myprocessors.length + mysourceports.length + mysinkports.length;
            Vertex[] v = new Vertex[graphsize];
            for (node = 0; node < myprocessors.length; ++node) {
                logger.debug((Object)myprocessors[node].getName().toString().toLowerCase());
                v[node] = new Vertex((Object)myprocessors[node].getName().toString().toLowerCase());
            }
            for (node = 0; node < mysourceports.length; ++node) {
                logger.debug((Object)mysourceports[node].toString().toLowerCase());
                v[myprocessors.length + node] = new Vertex((Object)mysourceports[node].getName().toString().toLowerCase());
            }
            for (node = 0; node < mysinkports.length; ++node) {
                logger.debug((Object)mysinkports[node].toString().toLowerCase());
                v[myprocessors.length + mysourceports.length + node] = new Vertex((Object)mysinkports[node].getName().toString().toLowerCase());
            }
            for (int vert = 0; vert < graphsize; ++vert) {
                graphmodel.addVertex(v[vert]);
            }
            if (logger.isDebugEnabled()) {
                for (int j = 0; j < graphsize; ++j) {
                    System.out.println("v[" + j + "].getLabel()");
                    System.out.println(v[j].getLabel());
                }
            }
            logger.debug((Object)"\nLinks\n");
            DataConstraint[] mylinks = model.getDataConstraints();
            for (int link = 0; link < mylinks.length; ++link) {
                if (logger.isDebugEnabled()) {
                    System.out.println("\n link = " + link);
                    if (mylinks[link].getSource().getProcessor().getName() == "SCUFL_INTERNAL_SOURCEPORTS") {
                        System.out.println("mylinks[" + link + "].getSource().getName()");
                        System.out.println(mylinks[link].getSource().getName());
                    } else {
                        System.out.println("mylinks[" + link + "].getSource().getProcessor().toString()");
                        System.out.println(mylinks[link].getSource().getProcessor().getName());
                    }
                }
                String source = "";
                source = mylinks[link].getSource().getProcessor().getName() == "SCUFL_INTERNAL_SOURCEPORTS" ? mylinks[link].getSource().getName() : mylinks[link].getSource().getProcessor().getName();
                for (int j = 0; j < graphsize; ++j) {
                    logger.debug((Object)("j = " + j));
                    if (mylinks[link].getSource().getProcessor().getName() == "SCUFL_INTERNAL_SOURCEPORTS") {
                        logger.debug((Object)("mylinks[" + link + "].getSource().getProcessor().toString() == SCUFL_INTERNAL_SOURCEPORTS"));
                        logger.debug((Object)("l = " + link));
                        if (v[j].getLabel() == mylinks[link].getSource().getName()) {
                            logger.debug((Object)("v[" + j + "].getLabel() == mylinks[" + link + "].getSource().getName()"));
                            this.assignEdge(graphsize, v, mylinks, link, j);
                        }
                    }
                    if (mylinks[link].getSource().getProcessor().getName() != v[j].getLabel()) continue;
                    logger.debug((Object)("mylinks[" + link + "].getSource().getProcessor().toString() == v[" + j + "].getLabel()"));
                    logger.debug((Object)("l = " + link));
                    if (v[j].getLabel() != mylinks[link].getSource().getProcessor().getName()) continue;
                    logger.debug((Object)("v[" + j + "].getLabel() == mylinks[" + link + "].getSource().toString()"));
                    this.assignEdge(graphsize, v, mylinks, link, j);
                }
                if (logger.isDebugEnabled()) {
                    if (mylinks[link].getSink().getProcessor().toString() == "SCUFL_INTERNAL_SINKPORTS") {
                        System.out.println("mylinks[" + link + "].getSink().toString()");
                        System.out.println(mylinks[link].getSink().toString());
                    } else {
                        System.out.println("mylinks[" + link + "].getSink().getProcessor().toString()");
                        System.out.println(mylinks[link].getSink().getProcessor().toString());
                    }
                }
                String target = "";
                target = mylinks[link].getSink().getProcessor().toString() == "SCUFL_INTERNAL_SINKPORTS" ? mylinks[link].getSink().toString() : mylinks[link].getSink().getProcessor().toString();
                this.setEdge(new GraphNode(source), new GraphNode(target));
            }
            if (logger.isDebugEnabled()) {
                System.out.println("************all nodes**************");
                for (IGraphNode n : this.getNodeSet()) {
                    System.out.println("node: " + n);
                    System.out.println("pre: " + n.getPredecessorSet());
                    System.out.println("suc: " + n.getSuccessorSet());
                }
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return graphmodel;
    }

    public Vertex[] assignEdge(int graphsize, Vertex[] inputVertex, DataConstraint[] inputDC, int link, int j) {
        for (int z = 0; z < graphsize; ++z) {
            if (logger.isDebugEnabled()) {
                System.out.println("v[z].getLabel()");
                System.out.println(inputVertex[z].getLabel());
                System.out.println("mylinks[link].getSink().getProcessor().getName()");
                System.out.println(inputDC[link].getSink().getProcessor().getName());
            }
            if (inputVertex[z].getLabel() == inputDC[link].getSink().getProcessor().getName()) {
                inputVertex[j].addEdge(inputVertex[z]);
            } else if (inputDC[link].getSink().getProcessor().toString() == "SCUFL_INTERNAL_SINKPORTS" && inputVertex[z].getLabel() == inputDC[link].getSink().toString()) {
                inputVertex[j].addEdge(inputVertex[z]);
            }
            logger.debug((Object)("z = " + z));
        }
        return inputVertex;
    }

    @Override
    public double getShortestPath(IGraphNode nodeA, IGraphNode nodeB) {
        return 0.0;
    }

    @Override
    public double getMaximumDirectedPathLength() {
        return 0.0;
    }

    @Override
    public Set<IGraphNode> getPredecessors(IGraphNode node, boolean direct) {
        return null;
    }

    @Override
    public Set<IGraphNode> getSuccessors(IGraphNode node, boolean direct) {
        return null;
    }

    @Override
    public IGraphNode getMostRecentCommonAncestor(IGraphNode nodeA, IGraphNode nodeB) {
        return null;
    }
}

