/*
 * Decompiled with CFR 0.152.
 */
package simpack.accessor.graph;

import cern.colt.matrix.impl.SparseDoubleMatrix2D;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Filter;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.log4j.Logger;
import simpack.api.IGraphNode;
import simpack.api.impl.AbstractGraphAccessor;
import simpack.exception.InvalidElementException;
import simpack.util.graph.GraphNode;
import simpack.util.graph.comparator.NamedGraphNodeComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JenaOntologyAccessor
extends AbstractGraphAccessor {
    public static Logger logger = Logger.getLogger(JenaOntologyAccessor.class);
    private OntModel model;
    private Filter anonFilter;
    private Filter sameNamespaceFilter;
    private String ontologyRootURI;
    private TreeMap<String, Integer> classURIsToIDsMap;
    private TreeMap<Integer, String> idsToClassURIsMap;
    private SparseDoubleMatrix2D shortestDistanceToDescendantOrChildMatrix;
    private SparseDoubleMatrix2D longestDistanceToDescendantOrChildMatrix;

    public JenaOntologyAccessor(String ontologyURI, String altOntologyURL, String ontologyBaseURI, String ontologyRootURI, OntModelSpec ontModelSpec) {
        this.setUpAccessor(ontologyURI, altOntologyURL, ontologyBaseURI, ontologyRootURI, ontModelSpec);
        this.parseHierarchy();
    }

    @Override
    public int size() {
        int size = 0;
        ExtendedIterator it = this.model.listClasses().filterDrop(this.anonFilter);
        while (it.hasNext()) {
            it.next();
            ++size;
        }
        logger.debug((Object)("Size of set is " + size));
        return size;
    }

    @Override
    public double getShortestPath(IGraphNode nodeA, IGraphNode nodeB) throws InvalidElementException {
        if (!this.contains(nodeA)) {
            throw new InvalidElementException("Node " + ((Object)nodeA).toString() + " is invalid");
        }
        if (!this.contains(nodeB)) {
            throw new InvalidElementException("Node " + ((Object)nodeB).toString() + " is invalid");
        }
        if (((Object)nodeA).toString().equals(((Object)nodeB).toString())) {
            return 0.0;
        }
        IGraphNode mrca = this.getMostRecentCommonAncestor(nodeA, nodeB);
        int idMRCA = this.classURIsToIDsMap.get(((Object)mrca).toString());
        int idA = this.classURIsToIDsMap.get(((Object)nodeA).toString());
        int idB = this.classURIsToIDsMap.get(((Object)nodeB).toString());
        return this.shortestDistanceToDescendantOrChildMatrix.getQuick(idMRCA, idA) + this.shortestDistanceToDescendantOrChildMatrix.getQuick(idMRCA, idB);
    }

    @Override
    public double getMaximumDirectedPathLength() {
        int ontologyRootID = this.classURIsToIDsMap.get(this.ontologyRootURI);
        double maxDepth = -2.147483648E9;
        int idMax = 0;
        logger.debug((Object)this.longestDistanceToDescendantOrChildMatrix.viewRow(ontologyRootID));
        for (int i = 0; i < this.longestDistanceToDescendantOrChildMatrix.columns(); ++i) {
            double temp = this.longestDistanceToDescendantOrChildMatrix.getQuick(ontologyRootID, i);
            if (!(temp > maxDepth)) continue;
            maxDepth = temp;
            idMax = i;
        }
        logger.debug((Object)("Maximum depth in ontology is " + maxDepth + " from " + this.ontologyRootURI + " to " + this.idsToClassURIsMap.get(idMax)));
        return maxDepth;
    }

    @Override
    public IGraphNode getRoot() {
        return new GraphNode(this.ontologyRootURI);
    }

    @Override
    public IGraphNode getMostRecentCommonAncestor(IGraphNode nodeA, IGraphNode nodeB) throws InvalidElementException {
        if (!this.contains(nodeA)) {
            throw new InvalidElementException("Node " + ((Object)nodeA).toString() + " is invalid");
        }
        if (!this.contains(nodeB)) {
            throw new InvalidElementException("Node " + ((Object)nodeB).toString() + " is invalid");
        }
        TreeSet<String> superClassesA = new TreeSet<String>();
        TreeSet<String> superClassesB = new TreeSet<String>();
        String classAURI = nodeA.getUserObject().toString();
        String classBURI = nodeB.getUserObject().toString();
        OntClass ontClassA = this.model.getOntClass(classAURI);
        OntClass ontClassB = this.model.getOntClass(classBURI);
        ExtendedIterator i = ontClassA.listSuperClasses().filterDrop(this.anonFilter);
        i = i.filterDrop(this.sameNamespaceFilter);
        while (i.hasNext()) {
            superClassesA.add(((OntClass)i.next()).getURI());
        }
        i = ontClassB.listSuperClasses().filterDrop(this.anonFilter);
        i = i.filterDrop(this.sameNamespaceFilter);
        while (i.hasNext()) {
            superClassesB.add(((OntClass)i.next()).getURI());
        }
        if (superClassesA.contains(classBURI)) {
            return new GraphNode(classBURI);
        }
        if (superClassesB.contains(classAURI)) {
            return new GraphNode(classAURI);
        }
        superClassesA.retainAll(superClassesB);
        int classAID = this.classURIsToIDsMap.get(classAURI);
        int classBID = this.classURIsToIDsMap.get(classBURI);
        int mrcaID = 0;
        double pathLength = 2.147483647E9;
        for (String commonAncestorURI : superClassesA) {
            logger.debug((Object)commonAncestorURI);
            int commonAncestorID = this.classURIsToIDsMap.get(commonAncestorURI);
            double d = this.shortestDistanceToDescendantOrChildMatrix.getQuick(commonAncestorID, classAID) + this.shortestDistanceToDescendantOrChildMatrix.getQuick(commonAncestorID, classBID);
            if (!(d < pathLength)) continue;
            pathLength = d;
            mrcaID = commonAncestorID;
        }
        if (logger.isDebugEnabled()) {
            OntClass mrca = this.model.getOntClass(this.idsToClassURIsMap.get(mrcaID));
            System.out.println("MRCA of " + ontClassA.getModel().shortForm(ontClassA.getURI()) + " and " + ontClassB.getModel().shortForm(ontClassB.getURI()) + " is " + mrca.getModel().shortForm(mrca.getURI()));
        }
        return new GraphNode(this.idsToClassURIsMap.get(mrcaID));
    }

    @Override
    public Set<IGraphNode> getSuccessors(IGraphNode node, boolean direct) throws InvalidElementException {
        OntResource resource = this.model.getOntResource(((Object)node).toString());
        if (resource != null && resource.isClass()) {
            TreeSet<IGraphNode> descendants = new TreeSet<IGraphNode>(new NamedGraphNodeComparator());
            OntClass clazz = resource.asClass();
            ExtendedIterator it = clazz.listSubClasses(direct).filterDrop(this.anonFilter);
            while (it.hasNext()) {
                descendants.add(new GraphNode(((OntClass)it.next()).getURI()));
            }
            return descendants;
        }
        throw new InvalidElementException("Node " + ((Object)node).toString() + " is invalid");
    }

    @Override
    public Set<IGraphNode> getPredecessors(IGraphNode node, boolean direct) throws InvalidElementException {
        OntResource resource = this.model.getOntResource(((Object)node).toString());
        if (resource != null && resource.isClass()) {
            TreeSet<IGraphNode> ancestors = new TreeSet<IGraphNode>(new NamedGraphNodeComparator());
            OntClass clazz = resource.asClass();
            ExtendedIterator it = clazz.listSuperClasses(direct).filterDrop(this.anonFilter);
            it = it.filterDrop(this.sameNamespaceFilter);
            while (it.hasNext()) {
                OntClass superClass = (OntClass)it.next();
                ancestors.add(new GraphNode(superClass.getURI()));
            }
            return ancestors;
        }
        throw new InvalidElementException("Node " + ((Object)node).toString() + " is invalid");
    }

    private void setUpAccessor(String ontologyURI, String altOntologyURL, String ontologyBaseURI, final String ontologyRootURI, OntModelSpec ontModelSpec) {
        this.model = ModelFactory.createOntologyModel((OntModelSpec)ontModelSpec);
        if (altOntologyURL != null) {
            this.model.getDocumentManager().addAltEntry(ontologyURI, altOntologyURL);
        }
        this.model.read(ontologyURI, ontologyBaseURI, null);
        this.ontologyRootURI = ontologyRootURI;
        this.anonFilter = new Filter(){

            public boolean accept(Object o) {
                return ((Resource)o).isAnon();
            }
        };
        this.sameNamespaceFilter = new Filter(){

            public boolean accept(Object o) {
                return !((Resource)o).getNameSpace().equals(JenaOntologyAccessor.this.model.getOntClass(ontologyRootURI).getNameSpace());
            }
        };
        this.calculateShortestAndLongestDistanceToDescendantOrChildMatrix();
    }

    private void calculateShortestAndLongestDistanceToDescendantOrChildMatrix() {
        int classID;
        Set<String> keys;
        TreeSet<String> classes = new TreeSet<String>();
        ExtendedIterator i = this.model.listClasses().filterDrop(this.anonFilter);
        while (i.hasNext()) {
            classes.add(((OntClass)i.next()).getURI());
        }
        this.classURIsToIDsMap = new TreeMap();
        int id = 0;
        for (String ontClassURI : classes) {
            this.classURIsToIDsMap.put(ontClassURI, id++);
        }
        if (logger.isDebugEnabled()) {
            keys = this.classURIsToIDsMap.keySet();
            for (String ontClassURI : keys) {
                classID = this.classURIsToIDsMap.get(ontClassURI);
                System.out.println("[" + ontClassURI + "," + classID + "]");
            }
        }
        this.idsToClassURIsMap = new TreeMap();
        keys = this.classURIsToIDsMap.keySet();
        for (String ontClassURI : keys) {
            classID = this.classURIsToIDsMap.get(ontClassURI);
            this.idsToClassURIsMap.put(classID, ontClassURI);
        }
        if (logger.isDebugEnabled()) {
            Set<Integer> set = this.idsToClassURIsMap.keySet();
            for (Integer classID2 : set) {
                String string = this.idsToClassURIsMap.get(classID2);
                System.out.println("[" + classID2 + "," + string + "]");
            }
        }
        this.shortestDistanceToDescendantOrChildMatrix = new SparseDoubleMatrix2D(classes.size(), classes.size());
        this.shortestDistanceToDescendantOrChildMatrix.viewPart(0, 0, this.shortestDistanceToDescendantOrChildMatrix.rows(), this.shortestDistanceToDescendantOrChildMatrix.columns()).assign(2.147483647E9);
        this.longestDistanceToDescendantOrChildMatrix = new SparseDoubleMatrix2D(classes.size(), classes.size());
        this.longestDistanceToDescendantOrChildMatrix.viewPart(0, 0, this.longestDistanceToDescendantOrChildMatrix.rows(), this.longestDistanceToDescendantOrChildMatrix.columns()).assign(-2.147483648E9);
        for (int row = 0; row < this.shortestDistanceToDescendantOrChildMatrix.rows(); ++row) {
            for (int column = 0; column < this.shortestDistanceToDescendantOrChildMatrix.columns(); ++column) {
                if (row != column) continue;
                this.shortestDistanceToDescendantOrChildMatrix.setQuick(row, column, 0.0);
                this.longestDistanceToDescendantOrChildMatrix.setQuick(row, column, 0.0);
            }
        }
        Vector indexSet = new Vector();
        keys = this.classURIsToIDsMap.keySet();
        for (String ontClassURI : keys) {
            int n = this.classURIsToIDsMap.get(ontClassURI);
            OntClass clazz = this.model.getOntClass(ontClassURI);
            ExtendedIterator it = clazz.listSubClasses(true);
            while (it.hasNext()) {
                OntClass child = (OntClass)it.next();
                if (logger.isDebugEnabled()) {
                    System.out.println("Class " + clazz.getModel().shortForm(clazz.getURI()) + " has child " + child.getModel().shortForm(child.getURI()));
                }
                int childID = this.classURIsToIDsMap.get(child.getURI());
                this.shortestDistanceToDescendantOrChildMatrix.setQuick(n, childID, 1.0);
                this.longestDistanceToDescendantOrChildMatrix.setQuick(n, childID, 1.0);
                Vector<Integer> pair = new Vector<Integer>();
                pair.add(n);
                pair.add(childID);
                indexSet.add(pair);
            }
        }
        while (!indexSet.isEmpty()) {
            Vector tempIndexSet = new Vector();
            for (Vector vector : indexSet) {
                int ancestorID = (Integer)vector.get(0);
                int descendantID = (Integer)vector.get(1);
                double valueShortestPath = this.shortestDistanceToDescendantOrChildMatrix.getQuick(ancestorID, descendantID);
                double valueLongestPath = this.longestDistanceToDescendantOrChildMatrix.getQuick(ancestorID, descendantID);
                String descendantURI = this.idsToClassURIsMap.get(descendantID);
                OntClass descendant = this.model.getOntClass(descendantURI);
                ExtendedIterator it = descendant.listSubClasses(true);
                while (it.hasNext()) {
                    OntClass grandDescendant = (OntClass)it.next();
                    int grandDescendantID = this.classURIsToIDsMap.get(grandDescendant.getURI());
                    double tempShortestPath = this.shortestDistanceToDescendantOrChildMatrix.getQuick(ancestorID, grandDescendantID);
                    double tempLongestPath = this.longestDistanceToDescendantOrChildMatrix.getQuick(ancestorID, grandDescendantID);
                    if (valueShortestPath + 1.0 < tempShortestPath) {
                        this.shortestDistanceToDescendantOrChildMatrix.setQuick(ancestorID, grandDescendantID, valueShortestPath + 1.0);
                    }
                    if (valueLongestPath + 1.0 > tempLongestPath) {
                        this.longestDistanceToDescendantOrChildMatrix.setQuick(ancestorID, grandDescendantID, valueLongestPath + 1.0);
                    }
                    Vector<Integer> p = new Vector<Integer>();
                    p.add(ancestorID);
                    p.add(grandDescendantID);
                    tempIndexSet.add(p);
                }
            }
            indexSet = tempIndexSet;
        }
    }

    private void parseClassDescription(OntClass c, String parent) {
        if (!c.isRestriction() && !c.isAnon()) {
            if (parent != null) {
                this.setEdge(new GraphNode(parent), new GraphNode(c.getURI()));
            } else {
                this.addNode(new GraphNode(c.getURI()));
            }
        }
    }

    private void parseClass(OntClass cls, List<OntClass> occurs, String parent) {
        this.parseClassDescription(cls, parent);
        if (cls.canAs(OntClass.class) && !occurs.contains(cls)) {
            ExtendedIterator i = cls.listSubClasses(true);
            while (i.hasNext()) {
                OntClass sub = (OntClass)i.next();
                String newParent = cls.getURI();
                occurs.add(cls);
                this.parseClass(sub, occurs, newParent);
                occurs.remove(cls);
            }
        }
    }

    private void parseHierarchy() {
        ExtendedIterator i = this.model.listHierarchyRootClasses().filterDrop(this.anonFilter);
        while (i.hasNext()) {
            OntClass root = (OntClass)i.next();
            this.parseClass(root, new ArrayList<OntClass>(), null);
        }
    }
}

