/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.checkstyle;

import com.google.common.collect.Maps;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang.StringUtils;
import org.codehaus.stax2.XMLInputFactory2;
import org.codehaus.staxmate.SMInputFactory;
import org.codehaus.staxmate.in.SMHierarchicCursor;
import org.codehaus.staxmate.in.SMInputCursor;
import org.sonar.api.profiles.ProfileImporter;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.rules.ActiveRule;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.RuleFinder;
import org.sonar.api.rules.RuleQuery;
import org.sonar.api.utils.ValidationMessages;
import org.sonar.plugins.checkstyle.CheckstyleSeverityUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckstyleProfileImporter
extends ProfileImporter {
    private static final String CHECKER_MODULE = "Checker";
    private static final String TREEWALKER_MODULE = "TreeWalker";
    private static final String MODULE_NODE = "module";
    private final RuleFinder ruleFinder;

    public CheckstyleProfileImporter(RuleFinder ruleFinder) {
        super("checkstyle", "Checkstyle");
        this.setSupportedLanguages(new String[]{"java"});
        this.ruleFinder = ruleFinder;
    }

    public RulesProfile importProfile(Reader reader, ValidationMessages messages) {
        SMInputFactory inputFactory = this.initStax();
        RulesProfile profile = RulesProfile.create();
        try {
            SMHierarchicCursor rootC = inputFactory.rootElementCursor(reader);
            rootC.advance();
            SMInputCursor rootModulesCursor = rootC.childElementCursor(MODULE_NODE);
            while (rootModulesCursor.getNext() != null) {
                String configKey = rootModulesCursor.getAttrValue("name");
                if (StringUtils.equals((String)TREEWALKER_MODULE, (String)configKey)) {
                    SMInputCursor treewalkerCursor = rootModulesCursor.childElementCursor(MODULE_NODE);
                    while (treewalkerCursor.getNext() != null) {
                        this.processModule(profile, "Checker/TreeWalker/", treewalkerCursor, messages);
                    }
                    continue;
                }
                this.processModule(profile, "Checker/", rootModulesCursor, messages);
            }
        }
        catch (XMLStreamException e) {
            messages.addErrorText("XML is not valid: " + e.getMessage());
        }
        return profile;
    }

    private SMInputFactory initStax() {
        XMLInputFactory xmlFactory = XMLInputFactory2.newInstance();
        xmlFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        xmlFactory.setProperty("javax.xml.stream.isNamespaceAware", Boolean.FALSE);
        xmlFactory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        xmlFactory.setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
        return new SMInputFactory(xmlFactory);
    }

    private void processModule(RulesProfile profile, String path, SMInputCursor moduleCursor, ValidationMessages messages) throws XMLStreamException {
        String moduleName = moduleCursor.getAttrValue("name");
        if (CheckstyleProfileImporter.isFilter(moduleName)) {
            messages.addWarningText("Checkstyle filters are not imported: " + moduleName);
        } else if (!CheckstyleProfileImporter.isIgnored(moduleName)) {
            this.processRule(profile, path, moduleName, moduleCursor, messages);
        }
    }

    static boolean isIgnored(String configKey) {
        return StringUtils.equals((String)configKey, (String)"FileContentsHolder");
    }

    static boolean isFilter(String configKey) {
        return StringUtils.equals((String)configKey, (String)"SuppressionCommentFilter") || StringUtils.equals((String)configKey, (String)"SeverityMatchFilter") || StringUtils.equals((String)configKey, (String)"SuppressionFilter") || StringUtils.equals((String)configKey, (String)"SuppressWithNearbyCommentFilter");
    }

    private void processRule(RulesProfile profile, String path, String moduleName, SMInputCursor moduleCursor, ValidationMessages messages) throws XMLStreamException {
        String warning;
        Rule rule;
        Map<String, String> properties = this.processProps(moduleCursor);
        String id = properties.get("id");
        if (StringUtils.isNotBlank((String)id)) {
            rule = this.ruleFinder.find(RuleQuery.create().withRepositoryKey("checkstyle").withKey(id));
            warning = "Checkstyle rule with key '" + id + "' not found";
        } else {
            String configKey = path + moduleName;
            rule = this.ruleFinder.find(RuleQuery.create().withRepositoryKey("checkstyle").withConfigKey(configKey));
            warning = "Checkstyle rule with config key '" + configKey + "' not found";
        }
        if (rule == null) {
            messages.addWarningText(warning);
        } else {
            ActiveRule activeRule = profile.activateRule(rule, null);
            this.activateProperties(activeRule, properties);
        }
    }

    private Map<String, String> processProps(SMInputCursor moduleCursor) throws XMLStreamException {
        HashMap props = Maps.newHashMap();
        SMInputCursor propertyCursor = moduleCursor.childElementCursor("property");
        while (propertyCursor.getNext() != null) {
            String key = propertyCursor.getAttrValue("name");
            String value = propertyCursor.getAttrValue("value");
            props.put(key, value);
        }
        return props;
    }

    private void activateProperties(ActiveRule activeRule, Map<String, String> properties) {
        for (Map.Entry<String, String> property : properties.entrySet()) {
            if (StringUtils.equals((String)"severity", (String)property.getKey())) {
                activeRule.setSeverity(CheckstyleSeverityUtils.fromSeverity(property.getValue()));
                continue;
            }
            if (StringUtils.equals((String)"id", (String)property.getKey())) continue;
            activeRule.setParameter(property.getKey(), property.getValue());
        }
    }
}

