/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.checkstyle;

import com.puppycrawl.tools.checkstyle.api.AuditEvent;
import com.puppycrawl.tools.checkstyle.api.AuditListener;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.BatchExtension;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.resources.JavaFile;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.RuleFinder;
import org.sonar.api.rules.Violation;

public class CheckstyleAuditListener
implements AuditListener,
BatchExtension {
    private final SensorContext context;
    private final Project project;
    private final RuleFinder ruleFinder;
    private Resource currentResource = null;

    public CheckstyleAuditListener(SensorContext context, Project project, RuleFinder ruleFinder) {
        this.context = context;
        this.project = project;
        this.ruleFinder = ruleFinder;
    }

    public void auditStarted(AuditEvent event) {
    }

    public void auditFinished(AuditEvent event) {
    }

    public void fileStarted(AuditEvent event) {
    }

    public void fileFinished(AuditEvent event) {
        this.currentResource = null;
    }

    public void addError(AuditEvent event) {
        Rule rule;
        String ruleKey = CheckstyleAuditListener.getRuleKey(event);
        if (ruleKey != null && (rule = this.ruleFinder.findByKey("checkstyle", ruleKey)) != null) {
            this.initResource(event);
            Violation violation = Violation.create((Rule)rule, (Resource)this.currentResource).setLineId(CheckstyleAuditListener.getLineId(event)).setMessage(CheckstyleAuditListener.getMessage(event));
            this.context.saveViolation(violation);
        }
    }

    private void initResource(AuditEvent event) {
        if (this.currentResource == null) {
            String absoluteFilename = event.getFileName();
            this.currentResource = JavaFile.fromAbsolutePath((String)absoluteFilename, (List)this.project.getFileSystem().getSourceDirs(), (boolean)false);
        }
    }

    static String getRuleKey(AuditEvent event) {
        String key = null;
        try {
            key = event.getModuleId();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (StringUtils.isBlank((String)key)) {
            try {
                key = event.getSourceName();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return key;
    }

    static String getMessage(AuditEvent event) {
        try {
            return event.getMessage();
        }
        catch (Exception e) {
            return null;
        }
    }

    static Integer getLineId(AuditEvent event) {
        try {
            int line = event.getLine();
            return line == 0 ? null : Integer.valueOf(line);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void addException(AuditEvent event, Throwable throwable) {
    }

    Resource getCurrentResource() {
        return this.currentResource;
    }
}

