/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.phases;

import com.google.common.collect.Lists;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.BatchComponent;
import org.sonar.api.batch.BatchExtensionDictionnary;
import org.sonar.api.batch.Sensor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.batch.maven.DependsUponMavenPlugin;
import org.sonar.api.batch.maven.MavenPluginHandler;
import org.sonar.api.resources.Project;
import org.sonar.api.utils.TimeProfiler;
import org.sonar.batch.MavenPluginExecutor;
import org.sonar.batch.events.EventBus;
import org.sonar.batch.phases.SensorExecutionEvent;
import org.sonar.batch.phases.SensorsPhaseEvent;

public class SensorsExecutor
implements BatchComponent {
    private static final Logger LOG = LoggerFactory.getLogger(SensorsExecutor.class);
    private Collection<Sensor> sensors;
    private MavenPluginExecutor mavenExecutor;
    private EventBus eventBus;

    public SensorsExecutor(BatchExtensionDictionnary selector, Project project, MavenPluginExecutor mavenExecutor, EventBus eventBus) {
        this.sensors = selector.select(Sensor.class, project, true);
        this.mavenExecutor = mavenExecutor;
        this.eventBus = eventBus;
    }

    public void execute(Project project, SensorContext context) {
        this.eventBus.fireEvent(new SensorsPhaseEvent(Lists.newArrayList(this.sensors), true));
        for (Sensor sensor : this.sensors) {
            this.executeMavenPlugin(project, sensor);
            this.eventBus.fireEvent(new SensorExecutionEvent(sensor, true));
            sensor.analyse(project, context);
            this.eventBus.fireEvent(new SensorExecutionEvent(sensor, false));
        }
        this.eventBus.fireEvent(new SensorsPhaseEvent(Lists.newArrayList(this.sensors), false));
    }

    private void executeMavenPlugin(Project project, Sensor sensor) {
        MavenPluginHandler handler;
        if (sensor instanceof DependsUponMavenPlugin && (handler = ((DependsUponMavenPlugin)sensor).getMavenPluginHandler(project)) != null) {
            TimeProfiler profiler = new TimeProfiler(LOG).start("Execute maven plugin " + handler.getArtifactId());
            this.mavenExecutor.execute(project, handler);
            profiler.stop();
        }
    }
}

