/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.index;

import org.sonar.api.database.DatabaseSession;
import org.sonar.api.database.model.RuleFailureModel;
import org.sonar.api.database.model.Snapshot;
import org.sonar.api.resources.Project;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.RuleFinder;
import org.sonar.api.rules.Violation;
import org.sonar.batch.index.ResourcePersister;

public final class ViolationPersister {
    private DatabaseSession session;
    private ResourcePersister resourcePersister;
    private RuleFinder ruleFinder;

    public ViolationPersister(DatabaseSession session, ResourcePersister resourcePersister, RuleFinder ruleFinder) {
        this.session = session;
        this.resourcePersister = resourcePersister;
        this.ruleFinder = ruleFinder;
    }

    void saveViolation(Project project, Violation violation) {
        this.saveViolation(project, violation, null, null);
    }

    public void saveViolation(Project project, Violation violation, RuleFailureModel pastViolation, String checksum) {
        Snapshot snapshot = this.resourcePersister.saveResource(project, violation.getResource());
        RuleFailureModel model = this.createModel(violation);
        if (pastViolation != null) {
            model.setCreatedAt(pastViolation.getCreatedAt());
            model.setPermanentId(pastViolation.getPermanentId());
            model.setSwitchedOff(pastViolation.isSwitchedOff());
        } else {
            model.setCreatedAt(snapshot.getCreatedAt());
        }
        model.setSnapshotId(snapshot.getId());
        model.setChecksum(checksum);
        this.session.saveWithoutFlush((Object)model);
        if (model.getPermanentId() == null) {
            model.setPermanentId(model.getId());
            this.session.saveWithoutFlush((Object)model);
        }
        violation.setMessage(model.getMessage());
        violation.setCreatedAt(model.getCreatedAt());
        violation.setSwitchedOff(model.isSwitchedOff());
    }

    public void commit() {
        this.session.commit();
    }

    private RuleFailureModel createModel(Violation violation) {
        RuleFailureModel model = new RuleFailureModel();
        Rule rule = this.ruleFinder.findByKey(violation.getRule().getRepositoryKey(), violation.getRule().getKey());
        model.setRuleId(rule.getId());
        model.setPriority(violation.getSeverity());
        model.setLine(violation.getLineId());
        model.setMessage(violation.getMessage());
        model.setCost(violation.getCost());
        return model;
    }
}

