/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch;

import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.project.MavenProject;
import org.sonar.api.utils.SonarException;
import org.sonar.batch.bootstrapper.ProjectDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MavenProjectConverter {
    private MavenProjectConverter() {
    }

    public static ProjectDefinition convert(List<MavenProject> poms, MavenProject root) {
        HashMap paths = Maps.newHashMap();
        HashMap defs = Maps.newHashMap();
        try {
            for (MavenProject mavenProject : poms) {
                String basedir = mavenProject.getBasedir().getCanonicalPath();
                paths.put(basedir, mavenProject);
                defs.put(mavenProject, MavenProjectConverter.convert(mavenProject));
            }
            for (Map.Entry entry : paths.entrySet()) {
                MavenProject pom = (MavenProject)entry.getValue();
                for (Object moduleId : pom.getModules()) {
                    File modulePath = new File(pom.getBasedir(), (String)moduleId);
                    MavenProject module = (MavenProject)paths.get(modulePath.getCanonicalPath());
                    ((ProjectDefinition)defs.get(pom)).addModule((ProjectDefinition)defs.get(module));
                }
            }
        }
        catch (IOException e) {
            throw new SonarException((Throwable)e);
        }
        return (ProjectDefinition)defs.get(root);
    }

    static ProjectDefinition convert(MavenProject pom) {
        Properties properties = new Properties();
        String key = pom.getGroupId() + ":" + pom.getArtifactId();
        MavenProjectConverter.setProperty(properties, "sonar.projectKey", key);
        MavenProjectConverter.setProperty(properties, "sonar.projectVersion", pom.getVersion());
        MavenProjectConverter.setProperty(properties, "sonar.projectName", pom.getName());
        MavenProjectConverter.setProperty(properties, "sonar.projectDescription", pom.getDescription());
        properties.putAll((Map<?, ?>)pom.getModel().getProperties());
        ProjectDefinition def = new ProjectDefinition(pom.getBasedir(), null, properties);
        def.addContainerExtension(pom);
        return def;
    }

    private static void setProperty(Properties properties, String key, String value) {
        if (value != null) {
            properties.setProperty(key, value);
        }
    }
}

