/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch;

import java.net.URLClassLoader;
import java.util.Arrays;
import org.apache.commons.configuration.Configuration;
import org.picocontainer.ComponentAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.Plugins;
import org.sonar.api.resources.Project;
import org.sonar.api.utils.HttpDownloader;
import org.sonar.api.utils.ServerHttpClient;
import org.sonar.batch.DefaultResourceCreationLock;
import org.sonar.batch.FakeMavenPluginExecutor;
import org.sonar.batch.MavenPluginExecutor;
import org.sonar.batch.Module;
import org.sonar.batch.ProjectBatch;
import org.sonar.batch.ProjectTree;
import org.sonar.batch.ServerMetadata;
import org.sonar.batch.bootstrap.BatchPluginRepository;
import org.sonar.batch.bootstrap.BootstrapClassLoader;
import org.sonar.batch.bootstrap.ExtensionDownloader;
import org.sonar.batch.bootstrap.TempDirectories;
import org.sonar.batch.components.PastMeasuresLoader;
import org.sonar.batch.components.PastSnapshotFinder;
import org.sonar.batch.components.PastSnapshotFinderByDate;
import org.sonar.batch.components.PastSnapshotFinderByDays;
import org.sonar.batch.components.PastSnapshotFinderByPreviousAnalysis;
import org.sonar.batch.components.PastSnapshotFinderByVersion;
import org.sonar.batch.index.DefaultIndex;
import org.sonar.batch.index.DefaultPersistenceManager;
import org.sonar.batch.index.DefaultResourcePersister;
import org.sonar.batch.index.DependencyPersister;
import org.sonar.batch.index.EventPersister;
import org.sonar.batch.index.LinkPersister;
import org.sonar.batch.index.MeasurePersister;
import org.sonar.batch.index.MemoryOptimizer;
import org.sonar.batch.index.SourcePersister;
import org.sonar.batch.index.ViolationPersister;
import org.sonar.core.components.CacheMetricFinder;
import org.sonar.core.components.CacheRuleFinder;
import org.sonar.core.plugin.JpaPluginDao;
import org.sonar.jpa.dao.MeasuresDao;
import org.sonar.jpa.session.DatabaseSessionProvider;
import org.sonar.jpa.session.DriverDatabaseConnector;
import org.sonar.jpa.session.ThreadLocalDatabaseSessionFactory;

public class Batch {
    private static final Logger LOG = LoggerFactory.getLogger(Batch.class);
    private Configuration configuration;
    private Object[] components;

    public Batch(Configuration configuration, Object ... components) {
        this.configuration = configuration;
        this.components = components;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        Module bootstrapComponents = null;
        try {
            bootstrapComponents = new BootstrapComponents().init().start();
            this.analyzeModules(bootstrapComponents);
        }
        finally {
            if (bootstrapComponents != null) {
                try {
                    bootstrapComponents.stop();
                }
                catch (Exception e) {
                    LOG.error("Fail to stop IoC container", (Throwable)e);
                }
            }
        }
    }

    private void analyzeModules(Module bootstrapComponents) {
        Module batchComponents = bootstrapComponents.installChild(new BatchComponents());
        batchComponents.start();
        ProjectTree projectTree = batchComponents.getComponent(ProjectTree.class);
        DefaultIndex index = batchComponents.getComponent(DefaultIndex.class);
        this.analyzeModule(batchComponents, index, projectTree.getRootProject());
    }

    boolean isMavenPluginExecutorRegistered() {
        for (Object component : this.components) {
            if (!(component instanceof Class) || !MavenPluginExecutor.class.isAssignableFrom((Class)component)) continue;
            return true;
        }
        return false;
    }

    private void analyzeModule(Module batchComponents, DefaultIndex index, Project project) {
        for (Project module : project.getModules()) {
            this.analyzeModule(batchComponents, index, module);
        }
        LOG.info("-------------  Analyzing {}", (Object)project.getName());
        Object[] exclusionPatterns = project.getExclusionPatterns();
        if (exclusionPatterns != null && exclusionPatterns.length > 0) {
            LOG.info("Excluded sources : {}", (Object)Arrays.toString(exclusionPatterns));
        }
        new ProjectBatch(batchComponents).execute(index, project);
    }

    private class BootstrapComponents
    extends Module {
        private BootstrapComponents() {
        }

        protected void configure() {
            this.addComponent(Batch.this.configuration);
            this.addComponent(ServerMetadata.class);
            this.addComponent(TempDirectories.class);
            this.addComponent(HttpDownloader.class);
            this.addComponent(ExtensionDownloader.class);
            this.addComponent(BootstrapClassLoader.class);
            URLClassLoader bootstrapClassLoader = this.getComponent(BootstrapClassLoader.class).getClassLoader();
            Thread.currentThread().setContextClassLoader(bootstrapClassLoader);
            this.addComponent(new DriverDatabaseConnector(Batch.this.configuration, (ClassLoader)bootstrapClassLoader));
            this.addComponent(ThreadLocalDatabaseSessionFactory.class);
            this.addAdapter((ComponentAdapter<?>)new DatabaseSessionProvider());
            for (Object component : Batch.this.components) {
                this.addComponent(component);
            }
            if (!Batch.this.isMavenPluginExecutorRegistered()) {
                this.addComponent(FakeMavenPluginExecutor.class);
            }
        }
    }

    private static class BatchComponents
    extends Module {
        private BatchComponents() {
        }

        protected void configure() {
            this.addComponent(ProjectTree.class);
            this.addComponent(DefaultResourceCreationLock.class);
            this.addComponent(DefaultIndex.class);
            this.addComponent(DefaultPersistenceManager.class);
            this.addComponent(DependencyPersister.class);
            this.addComponent(EventPersister.class);
            this.addComponent(LinkPersister.class);
            this.addComponent(MeasurePersister.class);
            this.addComponent(MemoryOptimizer.class);
            this.addComponent(DefaultResourcePersister.class);
            this.addComponent(SourcePersister.class);
            this.addComponent(ViolationPersister.class);
            this.addComponent(JpaPluginDao.class);
            this.addComponent(BatchPluginRepository.class);
            this.addComponent(Plugins.class);
            this.addComponent(ServerHttpClient.class);
            this.addComponent(MeasuresDao.class);
            this.addComponent(CacheRuleFinder.class);
            this.addComponent(CacheMetricFinder.class);
            this.addComponent(PastSnapshotFinderByDate.class);
            this.addComponent(PastSnapshotFinderByDays.class);
            this.addComponent(PastSnapshotFinderByPreviousAnalysis.class);
            this.addComponent(PastSnapshotFinderByVersion.class);
            this.addComponent(PastMeasuresLoader.class);
            this.addComponent(PastSnapshotFinder.class);
        }
    }
}

