/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.pmd.xml;

import java.util.ArrayList;
import java.util.List;
import org.sonar.plugins.pmd.xml.PmdProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PmdRule
implements Comparable<String> {
    private String ref;
    private String priority;
    private String name;
    private String message;
    private List<PmdProperty> properties = new ArrayList<PmdProperty>();
    private String clazz;

    public PmdRule(String ref) {
        this(ref, null);
    }

    public PmdRule(String ref, String priority) {
        this.ref = ref;
        this.priority = priority;
    }

    public String getRef() {
        return this.ref;
    }

    public void setProperties(List<PmdProperty> properties) {
        this.properties = properties;
    }

    public List<PmdProperty> getProperties() {
        return this.properties;
    }

    public PmdProperty getProperty(String propertyName) {
        for (PmdProperty prop : this.properties) {
            if (!propertyName.equals(prop.getName())) continue;
            return prop;
        }
        return null;
    }

    @Override
    public int compareTo(String o) {
        return o.compareTo(this.ref);
    }

    public String getPriority() {
        return this.priority;
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    public void addProperty(PmdProperty property) {
        if (this.properties == null) {
            this.properties = new ArrayList<PmdProperty>();
        }
        this.properties.add(property);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public String getClazz() {
        return this.clazz;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public void removeProperty(String propertyName) {
        PmdProperty prop = this.getProperty(propertyName);
        this.properties.remove(prop);
    }

    public void setClazz(String clazz) {
        this.clazz = clazz;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasProperties() {
        return this.properties != null && !this.properties.isEmpty();
    }
}

