/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.pmd;

import java.io.File;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang.StringUtils;
import org.codehaus.staxmate.in.SMHierarchicCursor;
import org.codehaus.staxmate.in.SMInputCursor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.resources.JavaFile;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.RuleFinder;
import org.sonar.api.rules.Violation;
import org.sonar.api.utils.StaxParser;

class PmdViolationsXmlParser {
    private Project project;
    private RuleFinder ruleFinder;
    private SensorContext context;

    public PmdViolationsXmlParser(Project project, RuleFinder ruleFinder, SensorContext context) {
        this.project = project;
        this.ruleFinder = ruleFinder;
        this.context = context;
    }

    public void parse(File file) throws XMLStreamException {
        StaxParser parser = new StaxParser((StaxParser.XmlStreamHandler)new StreamHandler(), true);
        parser.parse(file);
    }

    private class StreamHandler
    implements StaxParser.XmlStreamHandler {
        private StreamHandler() {
        }

        public void stream(SMHierarchicCursor rootCursor) throws XMLStreamException {
            rootCursor.advance();
            SMInputCursor fileCursor = rootCursor.descendantElementCursor("file");
            while (fileCursor.getNext() != null) {
                String name = fileCursor.getAttrValue("name");
                JavaFile resource = JavaFile.fromAbsolutePath((String)name, (List)PmdViolationsXmlParser.this.project.getFileSystem().getSourceDirs(), (boolean)false);
                if (PmdViolationsXmlParser.this.context.getResource((Resource)resource) == null) continue;
                this.streamViolations(fileCursor, (Resource)resource);
            }
        }

        private void streamViolations(SMInputCursor fileCursor, Resource resource) throws XMLStreamException {
            SMInputCursor violationCursor = fileCursor.descendantElementCursor("violation");
            while (violationCursor.getNext() != null) {
                int lineId = Integer.parseInt(violationCursor.getAttrValue("beginline"));
                String ruleKey = violationCursor.getAttrValue("rule");
                String message = StringUtils.trim((String)violationCursor.collectDescendantText());
                Rule rule = PmdViolationsXmlParser.this.ruleFinder.findByKey("pmd", ruleKey);
                if (rule == null) continue;
                Violation violation = Violation.create((Rule)rule, (Resource)resource).setLineId(Integer.valueOf(lineId)).setMessage(message);
                PmdViolationsXmlParser.this.context.saveViolation(violation);
            }
        }
    }
}

