/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.pmd;

import java.io.File;
import org.sonar.api.batch.Sensor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.resources.Project;
import org.sonar.api.rules.RuleFinder;
import org.sonar.api.utils.XmlParserException;
import org.sonar.plugins.pmd.PmdExecutor;
import org.sonar.plugins.pmd.PmdViolationsXmlParser;

public class PmdSensor
implements Sensor {
    private RulesProfile profile;
    private RuleFinder rulesFinder;
    private PmdExecutor executor;

    public PmdSensor(RulesProfile profile, RuleFinder rulesFinder, PmdExecutor executor) {
        this.profile = profile;
        this.rulesFinder = rulesFinder;
        this.executor = executor;
    }

    public void analyse(Project project, SensorContext context) {
        try {
            File xmlReport = this.executor.execute();
            this.getStaxParser(project, context).parse(xmlReport);
        }
        catch (Exception e) {
            throw new XmlParserException((Throwable)e);
        }
    }

    public boolean shouldExecuteOnProject(Project project) {
        return project.getFileSystem().hasJavaSourceFiles() && !this.profile.getActiveRulesByRepository("pmd").isEmpty();
    }

    private PmdViolationsXmlParser getStaxParser(Project project, SensorContext context) {
        return new PmdViolationsXmlParser(project, this.rulesFinder, context);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

