/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.pmd;

import java.io.Reader;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.profiles.ProfileImporter;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.rules.ActiveRule;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.RuleFinder;
import org.sonar.api.rules.RuleQuery;
import org.sonar.api.utils.ValidationMessages;
import org.sonar.plugins.pmd.PmdLevelUtils;
import org.sonar.plugins.pmd.xml.PmdProperty;
import org.sonar.plugins.pmd.xml.PmdRule;
import org.sonar.plugins.pmd.xml.PmdRuleset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PmdProfileImporter
extends ProfileImporter {
    private final RuleFinder ruleFinder;
    private static final Logger LOG = LoggerFactory.getLogger(PmdProfileImporter.class);

    public PmdProfileImporter(RuleFinder ruleFinder) {
        super("pmd", "PMD");
        this.setSupportedLanguages(new String[]{"java"});
        this.ruleFinder = ruleFinder;
    }

    public RulesProfile importProfile(Reader pmdConfigurationFile, ValidationMessages messages) {
        PmdRuleset pmdRuleset = this.parsePmdRuleset(pmdConfigurationFile, messages);
        return this.createRuleProfile(pmdRuleset, messages);
    }

    protected RulesProfile createRuleProfile(PmdRuleset pmdRuleset, ValidationMessages messages) {
        RulesProfile profile = RulesProfile.create();
        for (PmdRule pmdRule : pmdRuleset.getPmdRules()) {
            if ("net.sourceforge.pmd.rules.XPathRule".equals(pmdRule.getClazz())) {
                messages.addWarningText("PMD XPath rule '" + pmdRule.getName() + "' can't be imported automatically. The rule must be created manually through the Sonar web interface.");
                continue;
            }
            if (pmdRule.getRef() == null) {
                messages.addWarningText("A PMD rule without 'ref' attribute can't be imported. see '" + pmdRule.getClazz() + "'");
                continue;
            }
            Rule rule = this.ruleFinder.find(RuleQuery.create().withRepositoryKey("pmd").withConfigKey(pmdRule.getRef()));
            if (rule != null) {
                ActiveRule activeRule = profile.activateRule(rule, PmdLevelUtils.fromLevel(pmdRule.getPriority()));
                if (pmdRule.getProperties() == null) continue;
                for (PmdProperty prop : pmdRule.getProperties()) {
                    if (rule.getParam(prop.getName()) == null) {
                        messages.addWarningText("The property '" + prop.getName() + "' is not supported in the pmd rule: " + pmdRule.getRef());
                        continue;
                    }
                    activeRule.setParameter(prop.getName(), prop.getValue());
                }
                continue;
            }
            messages.addWarningText("Unable to import unknown PMD rule '" + pmdRule.getRef() + "'");
        }
        return profile;
    }

    protected PmdRuleset parsePmdRuleset(Reader pmdConfigurationFile, ValidationMessages messages) {
        try {
            SAXBuilder parser = new SAXBuilder();
            Document dom = parser.build(pmdConfigurationFile);
            Element eltResultset = dom.getRootElement();
            Namespace namespace = eltResultset.getNamespace();
            PmdRuleset pmdResultset = new PmdRuleset();
            for (Element eltRule : this.getChildren(eltResultset, "rule", namespace)) {
                PmdRule pmdRule = new PmdRule(eltRule.getAttributeValue("ref"));
                pmdRule.setClazz(eltRule.getAttributeValue("class"));
                pmdRule.setName(eltRule.getAttributeValue("name"));
                pmdRule.setMessage(eltRule.getAttributeValue("message"));
                this.parsePmdPriority(eltRule, pmdRule, namespace);
                this.parsePmdProperties(eltRule, pmdRule, namespace);
                pmdResultset.addRule(pmdRule);
            }
            return pmdResultset;
        }
        catch (Exception e) {
            String errorMessage = "The PMD configuration file is not valid";
            messages.addErrorText(errorMessage + " : " + e.getMessage());
            LOG.error(errorMessage, (Throwable)e);
            return new PmdRuleset();
        }
    }

    private List<Element> getChildren(Element parent, String childName, Namespace namespace) {
        if (namespace == null) {
            return parent.getChildren(childName);
        }
        return parent.getChildren(childName, namespace);
    }

    private void parsePmdProperties(Element eltRule, PmdRule pmdRule, Namespace namespace) {
        for (Element eltProperties : this.getChildren(eltRule, "properties", namespace)) {
            for (Element eltProperty : this.getChildren(eltProperties, "property", namespace)) {
                pmdRule.addProperty(new PmdProperty(eltProperty.getAttributeValue("name"), eltProperty.getAttributeValue("value")));
            }
        }
    }

    private void parsePmdPriority(Element eltRule, PmdRule pmdRule, Namespace namespace) {
        for (Element eltPriority : this.getChildren(eltRule, "priority", namespace)) {
            pmdRule.setPriority(eltPriority.getValue());
        }
    }
}

