/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.pmd;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.jdom.CDATA;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.sonar.api.profiles.ProfileExporter;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.rules.ActiveRule;
import org.sonar.api.rules.ActiveRuleParam;
import org.sonar.api.utils.SonarException;
import org.sonar.plugins.pmd.PmdLevelUtils;
import org.sonar.plugins.pmd.xml.PmdProperty;
import org.sonar.plugins.pmd.xml.PmdRule;
import org.sonar.plugins.pmd.xml.PmdRuleset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PmdProfileExporter
extends ProfileExporter {
    public PmdProfileExporter() {
        super("pmd", "PMD");
        this.setSupportedLanguages(new String[]{"java"});
        this.setMimeType("application/xml");
    }

    public void exportProfile(RulesProfile profile, Writer writer) {
        try {
            PmdRuleset tree = this.createPmdRuleset(profile.getActiveRulesByRepository("pmd"), profile.getName());
            String xmlModules = this.exportPmdRulesetToXml(tree);
            writer.append(xmlModules);
        }
        catch (IOException e) {
            throw new SonarException("Fail to export the profile " + profile, (Throwable)e);
        }
    }

    protected PmdRuleset createPmdRuleset(List<ActiveRule> activeRules, String profileName) {
        PmdRuleset ruleset = new PmdRuleset(profileName);
        for (ActiveRule activeRule : activeRules) {
            if (!activeRule.getRule().getRepositoryKey().equals("pmd")) continue;
            String configKey = activeRule.getRule().getConfigKey();
            PmdRule rule = new PmdRule(configKey, PmdLevelUtils.toLevel(activeRule.getSeverity()));
            if (activeRule.getActiveRuleParams() != null && !activeRule.getActiveRuleParams().isEmpty()) {
                ArrayList<PmdProperty> properties = new ArrayList<PmdProperty>();
                for (ActiveRuleParam activeRuleParam : activeRule.getActiveRuleParams()) {
                    properties.add(new PmdProperty(activeRuleParam.getRuleParam().getKey(), activeRuleParam.getValue()));
                }
                rule.setProperties(properties);
            }
            ruleset.addRule(rule);
            this.processXPathRule(activeRule.getRuleKey(), rule);
        }
        return ruleset;
    }

    protected void processXPathRule(String sonarRuleKey, PmdRule rule) {
        if ("net.sourceforge.pmd.rules.XPathRule".equals(rule.getRef())) {
            rule.setRef(null);
            PmdProperty xpathMessage = rule.getProperty("message");
            if (xpathMessage == null) {
                throw new SonarException("Property 'message' should be set for PMD rule " + sonarRuleKey);
            }
            rule.setMessage(xpathMessage.getValue());
            rule.removeProperty("message");
            PmdProperty xpathExp = rule.getProperty("xpath");
            if (xpathExp == null) {
                throw new SonarException("Property 'xpath' should be set for PMD rule " + sonarRuleKey);
            }
            xpathExp.setCdataValue(xpathExp.getValue());
            rule.setClazz("net.sourceforge.pmd.rules.XPathRule");
            rule.setName(sonarRuleKey);
        }
    }

    protected String exportPmdRulesetToXml(PmdRuleset pmdRuleset) {
        Element eltRuleset = new Element("ruleset");
        for (PmdRule pmdRule : pmdRuleset.getPmdRules()) {
            Element eltRule = new Element("rule");
            this.addAttribute(eltRule, "ref", pmdRule.getRef());
            this.addAttribute(eltRule, "class", pmdRule.getClazz());
            this.addAttribute(eltRule, "message", pmdRule.getMessage());
            this.addAttribute(eltRule, "name", pmdRule.getName());
            this.addChild(eltRule, "priority", pmdRule.getPriority());
            if (pmdRule.hasProperties()) {
                Element eltProperties = new Element("properties");
                eltRule.addContent((Content)eltProperties);
                for (PmdProperty prop : pmdRule.getProperties()) {
                    Element eltProperty = new Element("property");
                    eltProperty.setAttribute("name", prop.getName());
                    if (prop.isCdataValue()) {
                        Element eltValue = new Element("value");
                        eltValue.addContent((Content)new CDATA(prop.getCdataValue()));
                        eltProperty.addContent((Content)eltValue);
                    } else {
                        eltProperty.setAttribute("value", prop.getValue());
                    }
                    eltProperties.addContent((Content)eltProperty);
                }
            }
            eltRuleset.addContent((Content)eltRule);
        }
        XMLOutputter serializer = new XMLOutputter(Format.getPrettyFormat());
        StringWriter xml = new StringWriter();
        try {
            serializer.output(new Document(eltRuleset), (Writer)xml);
        }
        catch (IOException e) {
            throw new SonarException("A exception occured while generating the PMD configuration file.", (Throwable)e);
        }
        return xml.toString();
    }

    private void addChild(Element elt, String name, String text) {
        if (text != null) {
            elt.addContent((Content)new Element(name).setText(text));
        }
    }

    private void addAttribute(Element elt, String name, String value) {
        if (value != null) {
            elt.setAttribute(name, value);
        }
    }
}

