/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.pmd;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.PMDException;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RuleSetFactory;
import net.sourceforge.pmd.RuleSets;
import net.sourceforge.pmd.SourceType;
import net.sourceforge.pmd.renderers.XMLRenderer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.BatchExtension;
import org.sonar.api.resources.Java;
import org.sonar.api.resources.Language;
import org.sonar.api.resources.Project;
import org.sonar.api.utils.SonarException;
import org.sonar.api.utils.TimeProfiler;
import org.sonar.java.api.JavaUtils;
import org.sonar.plugins.pmd.PmdConfiguration;
import org.sonar.plugins.pmd.PmdVersion;

public class PmdExecutor
implements BatchExtension {
    private static final Logger LOG = LoggerFactory.getLogger(PmdExecutor.class);
    private PmdConfiguration configuration;
    private Project project;

    public PmdExecutor(Project project, PmdConfiguration configuration) {
        this.project = project;
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File execute() throws IOException, PMDException {
        TimeProfiler profiler = new TimeProfiler().start("Execute PMD " + PmdVersion.getVersion());
        ClassLoader initialClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            PMD pmd = new PMD();
            this.setJavaVersion(pmd, this.project);
            RuleContext ruleContext = new RuleContext();
            Report report = new Report();
            ruleContext.setReport(report);
            RuleSets rulesets = this.createRulesets();
            for (File file : this.project.getFileSystem().getSourceFiles(new Language[]{Java.INSTANCE})) {
                ruleContext.setSourceCodeFilename(file.getAbsolutePath());
                InputStreamReader fileReader = new InputStreamReader((InputStream)new FileInputStream(file), this.project.getFileSystem().getSourceCharset());
                try {
                    pmd.processFile((Reader)fileReader, rulesets, ruleContext);
                }
                catch (PMDException e) {
                    LOG.error("Fail to execute PMD. Following file is ignored: " + file, e.getCause());
                }
                catch (Exception e) {
                    LOG.error("Fail to execute PMD. Following file is ignored: " + file, (Throwable)e);
                }
                finally {
                    IOUtils.closeQuietly((Reader)fileReader);
                }
            }
            File file = this.writeXmlReport(this.project, report);
            return file;
        }
        finally {
            profiler.stop();
            Thread.currentThread().setContextClassLoader(initialClassLoader);
        }
    }

    private RuleSets createRulesets() {
        RuleSets rulesets = new RuleSets();
        RuleSetFactory ruleSetFactory = new RuleSetFactory();
        List<String> rulesetPaths = this.configuration.getRulesets();
        LOG.info("PMD configuration: " + StringUtils.join(rulesetPaths, (String)", "));
        for (String rulesetPath : rulesetPaths) {
            InputStream rulesInput = this.openRuleset(rulesetPath);
            rulesets.addRuleSet(ruleSetFactory.createRuleSet(rulesInput));
            IOUtils.closeQuietly((InputStream)rulesInput);
        }
        return rulesets;
    }

    private InputStream openRuleset(String rulesetPath) {
        try {
            boolean found;
            File file = new File(rulesetPath);
            if (file.exists()) {
                found = true;
            } else {
                file = new File(this.project.getFileSystem().getBasedir(), rulesetPath);
                found = file.exists();
            }
            if (found) {
                return new FileInputStream(file);
            }
            InputStream stream = this.getClass().getResourceAsStream(rulesetPath);
            if (stream == null) {
                throw new RuntimeException("The PMD ruleset can not be found: " + rulesetPath);
            }
            return stream;
        }
        catch (FileNotFoundException e) {
            throw new SonarException("The PMD ruleset can not be found: " + rulesetPath, (Throwable)e);
        }
    }

    private File writeXmlReport(Project project, Report report) throws IOException {
        XMLRenderer xmlRenderer = new XMLRenderer();
        StringWriter stringwriter = new StringWriter();
        xmlRenderer.setWriter((Writer)stringwriter);
        xmlRenderer.start();
        xmlRenderer.renderFileReport(report);
        xmlRenderer.end();
        File xmlReport = new File(project.getFileSystem().getSonarWorkingDirectory(), "pmd-result.xml");
        LOG.info("PMD output report: " + xmlReport.getAbsolutePath());
        FileUtils.write((File)xmlReport, (CharSequence)((Object)stringwriter).toString());
        return xmlReport;
    }

    static String getNormalizedJavaVersion(String javaVersion) {
        if (StringUtils.equals((String)"1.1", (String)javaVersion) || StringUtils.equals((String)"1.2", (String)javaVersion)) {
            javaVersion = "1.3";
        } else if (StringUtils.equals((String)"5", (String)javaVersion)) {
            javaVersion = "1.5";
        } else if (StringUtils.equals((String)"6", (String)javaVersion)) {
            javaVersion = "1.6";
        }
        return javaVersion;
    }

    private void setJavaVersion(PMD pmd, Project project) {
        String javaVersion = PmdExecutor.getNormalizedJavaVersion(JavaUtils.getSourceVersion((Project)project));
        if (javaVersion != null) {
            SourceType sourceType = SourceType.getSourceTypeForId((String)("java " + javaVersion));
            if (sourceType != null) {
                LOG.info("Java version: " + javaVersion);
                pmd.setJavaVersion(sourceType);
            } else {
                throw new SonarException("Unsupported Java version for PMD: " + javaVersion);
            }
        }
    }
}

