/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.pmd;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.List;
import org.sonar.api.BatchExtension;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.resources.Project;
import org.sonar.plugins.pmd.PmdProfileExporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PmdConfiguration
implements BatchExtension {
    private PmdProfileExporter pmdProfileExporter;
    private RulesProfile rulesProfile;
    private Project project;

    public PmdConfiguration(PmdProfileExporter pmdRulesRepository, RulesProfile rulesProfile, Project project) {
        this.pmdProfileExporter = pmdRulesRepository;
        this.rulesProfile = rulesProfile;
        this.project = project;
    }

    public List<String> getRulesets() {
        return Arrays.asList(this.saveXmlFile().getAbsolutePath());
    }

    private File saveXmlFile() {
        try {
            StringWriter pmdConfiguration = new StringWriter();
            this.pmdProfileExporter.exportProfile(this.rulesProfile, pmdConfiguration);
            return this.project.getFileSystem().writeToWorkingDirectory(pmdConfiguration.toString(), "pmd.xml");
        }
        catch (IOException e) {
            throw new RuntimeException("Fail to save the PMD configuration", e);
        }
    }
}

