/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.findbugs.xml;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.rules.RulePriority;
import org.sonar.plugins.findbugs.FindbugsLevelUtils;
import org.sonar.plugins.findbugs.xml.Bug;
import org.sonar.plugins.findbugs.xml.ClassFilter;
import org.sonar.plugins.findbugs.xml.FieldFilter;
import org.sonar.plugins.findbugs.xml.LocalFilter;
import org.sonar.plugins.findbugs.xml.Match;
import org.sonar.plugins.findbugs.xml.MethodFilter;
import org.sonar.plugins.findbugs.xml.OrFilter;
import org.sonar.plugins.findbugs.xml.PackageFilter;
import org.sonar.plugins.findbugs.xml.Priority;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XStreamAlias(value="FindBugsFilter")
public class FindBugsFilter {
    private static final String PATTERN_SEPARATOR = ",";
    private static final String CODE_SEPARATOR = ",";
    private static final String CATEGORY_SEPARATOR = ",";
    @XStreamImplicit
    private List<Match> matchs = new ArrayList<Match>();

    public String toXml() {
        XStream xstream = FindBugsFilter.createXStream();
        return xstream.toXML((Object)this);
    }

    public List<Match> getMatchs() {
        return this.matchs;
    }

    public List<Match> getChildren() {
        return this.matchs;
    }

    public void setMatchs(List<Match> matchs) {
        this.matchs = matchs;
    }

    public void addMatch(Match child) {
        this.matchs.add(child);
    }

    public Map<String, RulePriority> getPatternLevels(FindbugsLevelUtils priorityMapper) {
        BugInfoSplitter splitter = new BugInfoSplitter(){

            public String getSeparator() {
                return ",";
            }

            public String getVar(Bug bug) {
                return bug.getPattern();
            }
        };
        return this.processMatches(priorityMapper, splitter);
    }

    public Map<String, RulePriority> getCodeLevels(FindbugsLevelUtils priorityMapper) {
        BugInfoSplitter splitter = new BugInfoSplitter(){

            public String getSeparator() {
                return ",";
            }

            public String getVar(Bug bug) {
                return bug.getCode();
            }
        };
        return this.processMatches(priorityMapper, splitter);
    }

    public Map<String, RulePriority> getCategoryLevels(FindbugsLevelUtils priorityMapper) {
        BugInfoSplitter splitter = new BugInfoSplitter(){

            public String getSeparator() {
                return ",";
            }

            public String getVar(Bug bug) {
                return bug.getCategory();
            }
        };
        return this.processMatches(priorityMapper, splitter);
    }

    private RulePriority getRulePriority(Priority priority, FindbugsLevelUtils priorityMapper) {
        return priority != null ? priorityMapper.from(priority.getValue()) : null;
    }

    private Map<String, RulePriority> processMatches(FindbugsLevelUtils priorityMapper, BugInfoSplitter splitter) {
        HashMap<String, RulePriority> result = new HashMap<String, RulePriority>();
        for (Match child : this.getChildren()) {
            if (child.getOrs() != null) {
                for (OrFilter orFilter : child.getOrs()) {
                    this.completeLevels(result, orFilter.getBugs(), child.getPriority(), priorityMapper, splitter);
                }
            }
            if (child.getBug() == null) continue;
            this.completeLevels(result, Arrays.asList(child.getBug()), child.getPriority(), priorityMapper, splitter);
        }
        return result;
    }

    private void completeLevels(Map<String, RulePriority> result, List<Bug> bugs, Priority priority, FindbugsLevelUtils priorityMapper, BugInfoSplitter splitter) {
        if (bugs == null) {
            return;
        }
        RulePriority rulePriority = this.getRulePriority(priority, priorityMapper);
        for (Bug bug : bugs) {
            String[] splitted;
            String varToSplit = splitter.getVar(bug);
            if (StringUtils.isBlank((String)varToSplit)) continue;
            for (String code : splitted = StringUtils.split((String)varToSplit, (String)splitter.getSeparator())) {
                this.mapRulePriority(result, rulePriority, code);
            }
        }
    }

    private void mapRulePriority(Map<String, RulePriority> prioritiesByRule, RulePriority priority, String key) {
        if (prioritiesByRule.containsKey(key) && prioritiesByRule.get(key) != null) {
            if (prioritiesByRule.get(key).compareTo((Enum)priority) < 0) {
                prioritiesByRule.put(key, priority);
            }
        } else {
            prioritiesByRule.put(key, priority);
        }
    }

    public static XStream createXStream() {
        XStream xstream = new XStream();
        xstream.setClassLoader(FindBugsFilter.class.getClassLoader());
        xstream.processAnnotations(FindBugsFilter.class);
        xstream.processAnnotations(Match.class);
        xstream.processAnnotations(Bug.class);
        xstream.processAnnotations(Priority.class);
        xstream.processAnnotations(ClassFilter.class);
        xstream.processAnnotations(PackageFilter.class);
        xstream.processAnnotations(MethodFilter.class);
        xstream.processAnnotations(FieldFilter.class);
        xstream.processAnnotations(LocalFilter.class);
        xstream.processAnnotations(OrFilter.class);
        return xstream;
    }

    private static interface BugInfoSplitter {
        public String getVar(Bug var1);

        public String getSeparator();
    }
}

