/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.findbugs;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import org.codehaus.staxmate.SMInputFactory;
import org.codehaus.staxmate.in.SMInputCursor;
import org.sonar.api.utils.SonarException;
import org.sonar.api.utils.XmlParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FindbugsXmlReportParser {
    private final File findbugsXmlReport;
    private final String findbugsXmlReportPath;

    public FindbugsXmlReportParser(File findbugsXmlReport) {
        this.findbugsXmlReport = findbugsXmlReport;
        this.findbugsXmlReportPath = findbugsXmlReport.getAbsolutePath();
        if (!findbugsXmlReport.exists()) {
            throw new SonarException("The findbugs XML report can't be found at '" + this.findbugsXmlReportPath + "'");
        }
    }

    public List<Violation> getViolations() {
        ArrayList<Violation> violations = new ArrayList<Violation>();
        try {
            SMInputFactory inf = new SMInputFactory(XMLInputFactory.newInstance());
            SMInputCursor cursor = inf.rootElementCursor(this.findbugsXmlReport).advance();
            SMInputCursor bugInstanceCursor = cursor.childElementCursor("BugInstance").advance();
            while (bugInstanceCursor.asEvent() != null) {
                String type = bugInstanceCursor.getAttrValue("type");
                String longMessage = "";
                SMInputCursor bugInstanceChildCursor = bugInstanceCursor.childElementCursor().advance();
                while (bugInstanceChildCursor.asEvent() != null) {
                    String nodeName = bugInstanceChildCursor.getLocalName();
                    if ("LongMessage".equals(nodeName)) {
                        longMessage = bugInstanceChildCursor.collectDescendantText();
                    } else if ("SourceLine".equals(nodeName)) {
                        Violation fbViolation = new Violation();
                        fbViolation.type = type;
                        fbViolation.longMessage = longMessage;
                        fbViolation.parseStart(bugInstanceChildCursor.getAttrValue("start"));
                        fbViolation.parseEnd(bugInstanceChildCursor.getAttrValue("end"));
                        fbViolation.className = bugInstanceChildCursor.getAttrValue("classname");
                        fbViolation.sourcePath = bugInstanceChildCursor.getAttrValue("sourcepath");
                        violations.add(fbViolation);
                    }
                    bugInstanceChildCursor.advance();
                }
                bugInstanceCursor.advance();
            }
            cursor.getStreamReader().closeCompletely();
        }
        catch (XMLStreamException e) {
            throw new XmlParserException("Unable to parse the Findbugs XML Report '" + this.findbugsXmlReportPath + "'", (Throwable)e);
        }
        return violations;
    }

    public static class Violation {
        private String type;
        private String longMessage;
        private Integer start;
        private Integer end;
        protected String className;
        protected String sourcePath;

        public String getType() {
            return this.type;
        }

        public void parseStart(String attrValue) {
            try {
                this.start = Integer.parseInt(attrValue);
            }
            catch (NumberFormatException e) {
                this.start = null;
            }
        }

        public void parseEnd(String attrValue) {
            try {
                this.end = Integer.parseInt(attrValue);
            }
            catch (NumberFormatException e) {
                this.end = null;
            }
        }

        public String getLongMessage() {
            return this.longMessage;
        }

        public Integer getStart() {
            return this.start;
        }

        public Integer getEnd() {
            return this.end;
        }

        public String getClassName() {
            return this.className;
        }

        public String getSourcePath() {
            return this.sourcePath;
        }

        public String getSonarJavaFileKey() {
            if (this.className.indexOf(36) > -1) {
                return this.className.substring(0, this.className.indexOf(36));
            }
            return this.className;
        }
    }
}

