/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.findbugs;

import java.io.File;
import java.util.List;
import org.sonar.api.batch.Sensor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.resources.JavaFile;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.RuleFinder;
import org.sonar.api.rules.Violation;
import org.sonar.api.utils.Logs;
import org.sonar.plugins.findbugs.FindbugsExecutor;
import org.sonar.plugins.findbugs.FindbugsXmlReportParser;

public class FindbugsSensor
implements Sensor {
    private RulesProfile profile;
    private RuleFinder ruleFinder;
    private FindbugsExecutor executor;

    public FindbugsSensor(RulesProfile profile, RuleFinder ruleFinder, FindbugsExecutor executor) {
        this.profile = profile;
        this.ruleFinder = ruleFinder;
        this.executor = executor;
    }

    public boolean shouldExecuteOnProject(Project project) {
        return project.getFileSystem().hasJavaSourceFiles() && !this.profile.getActiveRulesByRepository("findbugs").isEmpty();
    }

    public void analyse(Project project, SensorContext context) {
        File report;
        if (project.getReuseExistingRulesConfig()) {
            Logs.INFO.warn("Reusing existing Findbugs configuration not supported any more.");
        }
        if ((report = this.getFindbugsReportFile(project)) == null) {
            report = this.executor.execute();
        }
        FindbugsXmlReportParser reportParser = new FindbugsXmlReportParser(report);
        List<FindbugsXmlReportParser.Violation> fbViolations = reportParser.getViolations();
        for (FindbugsXmlReportParser.Violation fbViolation : fbViolations) {
            Rule rule = this.ruleFinder.findByKey("findbugs", fbViolation.getType());
            if (rule != null) {
                JavaFile resource = new JavaFile(fbViolation.getSonarJavaFileKey());
                if (context.getResource((Resource)resource) == null) continue;
                Violation violation = Violation.create((Rule)rule, (Resource)resource).setLineId(fbViolation.getStart()).setMessage(fbViolation.getLongMessage());
                context.saveViolation(violation);
                continue;
            }
            Logs.INFO.warn("Findbugs rule '{}' not active in Sonar.", (Object)fbViolation.getType());
        }
    }

    protected final File getFindbugsReportFile(Project project) {
        if (project.getConfiguration().getString("sonar.findbugs.reportPath") != null) {
            return new File(project.getConfiguration().getString("sonar.findbugs.reportPath"));
        }
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

