/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.findbugs;

import com.thoughtworks.xstream.XStream;
import java.io.Reader;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.profiles.ProfileImporter;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.RuleFinder;
import org.sonar.api.rules.RulePriority;
import org.sonar.api.rules.RuleQuery;
import org.sonar.api.utils.ValidationMessages;
import org.sonar.plugins.findbugs.FindbugsCategory;
import org.sonar.plugins.findbugs.FindbugsLevelUtils;
import org.sonar.plugins.findbugs.xml.FindBugsFilter;

public class FindbugsProfileImporter
extends ProfileImporter {
    private final RuleFinder ruleFinder;
    private static final Logger LOG = LoggerFactory.getLogger(FindbugsProfileImporter.class);

    public FindbugsProfileImporter(RuleFinder ruleFinder) {
        super("findbugs", "Findbugs");
        this.setSupportedLanguages(new String[]{"java"});
        this.ruleFinder = ruleFinder;
    }

    public RulesProfile importProfile(Reader findbugsConf, ValidationMessages messages) {
        RulesProfile profile = RulesProfile.create();
        try {
            XStream xStream = FindBugsFilter.createXStream();
            FindBugsFilter filter = (FindBugsFilter)xStream.fromXML(findbugsConf);
            this.activateRulesByCategory(profile, filter, messages);
            this.activateRulesByCode(profile, filter, messages);
            this.activateRulesByPattern(profile, filter, messages);
            return profile;
        }
        catch (Exception e) {
            String errorMessage = "The Findbugs configuration file is not valid";
            messages.addErrorText(errorMessage + " : " + e.getMessage());
            LOG.error(errorMessage, (Throwable)e);
            return profile;
        }
    }

    private void activateRulesByPattern(RulesProfile profile, FindBugsFilter filter, ValidationMessages messages) {
        for (Map.Entry<String, RulePriority> patternLevel : filter.getPatternLevels(new FindbugsLevelUtils()).entrySet()) {
            Rule rule = this.ruleFinder.findByKey("findbugs", patternLevel.getKey());
            if (rule != null) {
                profile.activateRule(rule, patternLevel.getValue());
                continue;
            }
            messages.addWarningText("Unable to activate unknown rule : '" + patternLevel.getKey() + "'");
        }
    }

    private void activateRulesByCode(RulesProfile profile, FindBugsFilter filter, ValidationMessages messages) {
        for (Map.Entry<String, RulePriority> codeLevel : filter.getCodeLevels(new FindbugsLevelUtils()).entrySet()) {
            boolean someRulesHaveBeenActivated = false;
            for (Rule rule : this.ruleFinder.findAll(RuleQuery.create().withRepositoryKey("findbugs"))) {
                if (!rule.getKey().equals(codeLevel.getKey()) && !StringUtils.startsWith((String)rule.getKey(), (String)(codeLevel.getKey() + "_"))) continue;
                someRulesHaveBeenActivated = true;
                profile.activateRule(rule, codeLevel.getValue());
            }
            if (someRulesHaveBeenActivated) continue;
            messages.addWarningText("Unable to find any rules associated to code  : '" + codeLevel.getKey() + "'");
        }
    }

    private void activateRulesByCategory(RulesProfile profile, FindBugsFilter filter, ValidationMessages messages) {
        for (Map.Entry<String, RulePriority> categoryLevel : filter.getCategoryLevels(new FindbugsLevelUtils()).entrySet()) {
            boolean someRulesHaveBeenActivated = false;
            String sonarCateg = FindbugsCategory.findbugsToSonar(categoryLevel.getKey());
            for (Rule rule : this.ruleFinder.findAll(RuleQuery.create().withRepositoryKey("findbugs"))) {
                if (sonarCateg == null || !rule.getName().startsWith(sonarCateg)) continue;
                someRulesHaveBeenActivated = true;
                profile.activateRule(rule, categoryLevel.getValue());
            }
            if (someRulesHaveBeenActivated) continue;
            messages.addWarningText("Unable to find any rules associated to category  : '" + categoryLevel.getKey() + "'");
        }
    }
}

