/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.findbugs;

import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.sonar.api.profiles.ProfileExporter;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.rules.ActiveRule;
import org.sonar.api.utils.SonarException;
import org.sonar.plugins.findbugs.xml.Bug;
import org.sonar.plugins.findbugs.xml.FindBugsFilter;
import org.sonar.plugins.findbugs.xml.Match;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindbugsProfileExporter
extends ProfileExporter {
    public FindbugsProfileExporter() {
        super("findbugs", "Findbugs");
        this.setSupportedLanguages(new String[]{"java"});
        this.setMimeType("application/xml");
    }

    public void exportProfile(RulesProfile profile, Writer writer) {
        try {
            FindBugsFilter filter = FindbugsProfileExporter.buildFindbugsFilter(profile.getActiveRulesByRepository("findbugs"));
            XStream xstream = FindBugsFilter.createXStream();
            writer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!-- Generated by Sonar -->\n".concat(xstream.toXML((Object)filter)));
        }
        catch (IOException e) {
            throw new SonarException("Fail to export the Findbugs profile : " + profile, (Throwable)e);
        }
    }

    protected static FindBugsFilter buildFindbugsFilter(List<ActiveRule> activeRules) {
        FindBugsFilter root = new FindBugsFilter();
        for (ActiveRule activeRule : activeRules) {
            if (!"findbugs".equals(activeRule.getRepositoryKey())) continue;
            Match child = new Match();
            child.setBug(new Bug(activeRule.getConfigKey()));
            root.addMatch(child);
        }
        return root;
    }
}

