/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.findbugs;

import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.FindBugs;
import edu.umd.cs.findbugs.FindBugs2;
import edu.umd.cs.findbugs.Plugin;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.XMLBugReporter;
import edu.umd.cs.findbugs.config.UserPreferences;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.BatchExtension;
import org.sonar.api.utils.Logs;
import org.sonar.api.utils.SonarException;
import org.sonar.api.utils.TimeProfiler;
import org.sonar.plugins.findbugs.FindbugsConfiguration;
import org.sonar.plugins.findbugs.FindbugsVersion;

public class FindbugsExecutor
implements BatchExtension {
    private static final Logger LOG = LoggerFactory.getLogger(FindbugsExecutor.class);
    private FindbugsConfiguration configuration;

    public FindbugsExecutor(FindbugsConfiguration configuration) {
        this.configuration = configuration;
    }

    public File execute() {
        File file;
        TimeProfiler profiler = new TimeProfiler().start("Execute Findbugs " + FindbugsVersion.getVersion());
        ClassLoader initialClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(FindBugs2.class.getClassLoader());
        Object xmlOutput = null;
        try {
            DetectorFactoryCollection detectorFactory = this.loadFindbugsPlugins();
            FindBugs2 engine = new FindBugs2();
            Project project = this.configuration.getFindbugsProject();
            engine.setProject(project);
            XMLBugReporter xmlBugReporter = new XMLBugReporter(project);
            xmlBugReporter.setPriorityThreshold(3);
            xmlBugReporter.setAddMessages(true);
            File xmlReport = this.configuration.getTargetXMLReport();
            if (xmlReport != null) {
                LOG.info("Findbugs output report: " + xmlReport.getAbsolutePath());
                xmlOutput = FileUtils.openOutputStream((File)xmlReport);
            } else {
                xmlOutput = new NullOutputStream();
            }
            xmlBugReporter.setOutputStream(new PrintStream((OutputStream)xmlOutput));
            engine.setBugReporter((BugReporter)xmlBugReporter);
            UserPreferences userPreferences = UserPreferences.createDefaultUserPreferences();
            userPreferences.setEffort(this.configuration.getEffort());
            engine.setUserPreferences(userPreferences);
            engine.addFilter(this.configuration.saveIncludeConfigXml().getAbsolutePath(), true);
            engine.addFilter(this.configuration.saveExcludeConfigXml().getAbsolutePath(), false);
            engine.setDetectorFactoryCollection(detectorFactory);
            engine.setAnalysisFeatureSettings(FindBugs.DEFAULT_EFFORT);
            engine.finishSettings();
            Executors.newSingleThreadExecutor().submit(new FindbugsTask(engine)).get(this.configuration.getTimeout(), TimeUnit.MILLISECONDS);
            profiler.stop();
            FindbugsExecutor.resetDetectorFactoryCollection();
            file = xmlReport;
        }
        catch (Exception e) {
            try {
                throw new SonarException("Can not execute Findbugs", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(xmlOutput);
                Thread.currentThread().setContextClassLoader(initialClassLoader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)xmlOutput);
        Thread.currentThread().setContextClassLoader(initialClassLoader);
        return file;
    }

    private DetectorFactoryCollection loadFindbugsPlugins() {
        ArrayList plugins = Lists.newArrayList();
        try {
            Enumeration<URL> urls = Thread.currentThread().getContextClassLoader().getResources("findbugs.xml");
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                String path = StringUtils.removeStart((String)StringUtils.substringBefore((String)url.toString(), (String)"!"), (String)"jar:");
                Logs.INFO.info("Found findbugs plugin: " + path);
                plugins.add(new URL(path));
            }
        }
        catch (IOException e) {
            throw new SonarException((Throwable)e);
        }
        FindbugsExecutor.resetDetectorFactoryCollection();
        DetectorFactoryCollection detectorFactory = DetectorFactoryCollection.rawInstance();
        detectorFactory.setPluginList(plugins.toArray(new URL[plugins.size()]));
        for (Plugin plugin : detectorFactory.plugins()) {
            Logs.INFO.info("Loaded plugin " + plugin.getPluginId());
        }
        return detectorFactory;
    }

    private static void resetDetectorFactoryCollection() {
        try {
            Field field = DetectorFactoryCollection.class.getDeclaredField("theInstance");
            field.setAccessible(true);
            field.set(null, null);
        }
        catch (Exception e) {
            throw new SonarException((Throwable)e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FindbugsTask
    implements Callable<Object> {
        private FindBugs2 engine;

        public FindbugsTask(FindBugs2 engine) {
            this.engine = engine;
        }

        @Override
        public Object call() throws Exception {
            this.engine.execute();
            return null;
        }
    }
}

