/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.findbugs;

import edu.umd.cs.findbugs.Project;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.BatchExtension;
import org.sonar.api.batch.ProjectClasspath;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.utils.SonarException;
import org.sonar.plugins.findbugs.FindbugsAntConverter;
import org.sonar.plugins.findbugs.FindbugsProfileExporter;
import org.sonar.plugins.findbugs.FindbugsVersion;
import org.sonar.plugins.findbugs.xml.ClassFilter;
import org.sonar.plugins.findbugs.xml.FindBugsFilter;
import org.sonar.plugins.findbugs.xml.Match;

public class FindbugsConfiguration
implements BatchExtension {
    private org.sonar.api.resources.Project project;
    private RulesProfile profile;
    private FindbugsProfileExporter exporter;
    private ProjectClasspath projectClasspath;
    private File jsr305Lib;
    private File annotationsLib;

    public FindbugsConfiguration(org.sonar.api.resources.Project project, RulesProfile profile, FindbugsProfileExporter exporter, ProjectClasspath classpath) {
        this.project = project;
        this.profile = profile;
        this.exporter = exporter;
        this.projectClasspath = classpath;
    }

    public File getTargetXMLReport() {
        if (this.project.getConfiguration().getBoolean("sonar.findbugs.generateXml", true)) {
            return new File(this.project.getFileSystem().getSonarWorkingDirectory(), "findbugs-result.xml");
        }
        return null;
    }

    public Project getFindbugsProject() {
        File classesDir = this.project.getFileSystem().getBuildOutputDir();
        if (classesDir == null || !classesDir.exists()) {
            throw new SonarException("Findbugs needs sources to be compiled. Please build project before executing sonar and check the location of compiled classes.");
        }
        Project findbugsProject = new Project();
        for (File dir : this.project.getFileSystem().getSourceDirs()) {
            findbugsProject.addSourceDir(dir.getAbsolutePath());
        }
        findbugsProject.addFile(classesDir.getAbsolutePath());
        for (File file : this.projectClasspath.getElements()) {
            if (file.equals(classesDir)) continue;
            findbugsProject.addAuxClasspathEntry(file.getAbsolutePath());
        }
        findbugsProject.addAuxClasspathEntry(this.annotationsLib.getAbsolutePath());
        findbugsProject.addAuxClasspathEntry(this.jsr305Lib.getAbsolutePath());
        findbugsProject.setCurrentWorkingDirectory(this.project.getFileSystem().getBuildDir());
        return findbugsProject;
    }

    public File saveIncludeConfigXml() throws IOException {
        StringWriter conf = new StringWriter();
        this.exporter.exportProfile(this.profile, conf);
        return this.project.getFileSystem().writeToWorkingDirectory(conf.toString(), "findbugs-include.xml");
    }

    public File saveExcludeConfigXml() throws IOException {
        FindBugsFilter findBugsFilter = new FindBugsFilter();
        if (this.project.getExclusionPatterns() != null) {
            for (String exclusion : this.project.getExclusionPatterns()) {
                ClassFilter classFilter = new ClassFilter(FindbugsAntConverter.antToJavaRegexpConvertor(exclusion));
                findBugsFilter.addMatch(new Match(classFilter));
            }
        }
        return this.project.getFileSystem().writeToWorkingDirectory(findBugsFilter.toXml(), "findbugs-exclude.xml");
    }

    public String getEffort() {
        return StringUtils.lowerCase((String)this.project.getConfiguration().getString("sonar.findbugs.effort", "Default"));
    }

    public long getTimeout() {
        return this.project.getConfiguration().getLong("sonar.findbugs.timeout", 600000L);
    }

    public void start() {
        this.jsr305Lib = this.copyLib("/jsr305-" + FindbugsVersion.getVersion() + ".jar");
        this.annotationsLib = this.copyLib("/annotations-" + FindbugsVersion.getVersion() + ".jar");
    }

    public void stop() {
        this.jsr305Lib.delete();
        this.annotationsLib.delete();
    }

    private File copyLib(String name) {
        try {
            InputStream is = this.getClass().getResourceAsStream(name);
            File temp = File.createTempFile("findbugs", ".jar");
            FileOutputStream os = FileUtils.openOutputStream((File)temp);
            IOUtils.copy((InputStream)is, (OutputStream)os);
            return temp;
        }
        catch (IOException e) {
            throw new SonarException((Throwable)e);
        }
    }
}

