/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.findbugs;

import org.apache.commons.lang.StringUtils;
import org.sonar.api.resources.Java;

public final class FindbugsAntConverter {
    private FindbugsAntConverter() {
    }

    public static String antToJavaRegexpConvertor(String exclusion) {
        StringBuilder builder = new StringBuilder("~");
        int offset = 0;
        if (exclusion.startsWith("**/")) {
            builder.append("(.*\\.)?");
            offset += 3;
        } else if (exclusion.startsWith("*/")) {
            builder.append("([^\\\\^\\s]*\\.)?");
            offset += 2;
        }
        for (String suffix : Java.SUFFIXES) {
            exclusion = StringUtils.removeEndIgnoreCase((String)exclusion, (String)("." + suffix));
        }
        char[] array = exclusion.toCharArray();
        for (int i = offset; i < array.length; ++i) {
            char c = array[i];
            if (c == '?') {
                builder.append('.');
                continue;
            }
            if (c == '*') {
                if (i + 1 < array.length && array[i + 1] == '*') {
                    builder.append(".*");
                    ++i;
                    continue;
                }
                builder.append("[^\\\\^\\s]*");
                continue;
            }
            if (c == '/') {
                builder.append("\\.");
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }
}

