/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.wsclient.services;

import org.sonar.wsclient.services.Review;
import org.sonar.wsclient.services.UpdateQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReviewUpdateQuery
extends UpdateQuery<Review> {
    private long reviewId;
    private String action;
    private String comment;
    private String assignee;
    private String resolution;

    public static ReviewUpdateQuery addComment(long id, String comment) {
        return new ReviewUpdateQuery(id, "add_comment").setComment(comment);
    }

    public static ReviewUpdateQuery reassign(long id, String assignee) {
        return new ReviewUpdateQuery(id, "reassign").setAssignee(assignee);
    }

    public static ReviewUpdateQuery resolve(long id, String resolution) {
        return new ReviewUpdateQuery(id, "resolve").setResolution(resolution);
    }

    public static ReviewUpdateQuery reopen(long id) {
        return new ReviewUpdateQuery(id, "reopen");
    }

    private ReviewUpdateQuery(long id, String action) {
        this.reviewId = id;
        this.action = action;
    }

    public long getReviewId() {
        return this.reviewId;
    }

    public ReviewUpdateQuery setComment(String comment) {
        this.comment = comment;
        return this;
    }

    public String getComment() {
        return this.comment;
    }

    public String getAssignee() {
        return this.assignee;
    }

    public ReviewUpdateQuery setAssignee(String userLogin) {
        this.assignee = userLogin;
        return this;
    }

    public String getResolution() {
        return this.resolution;
    }

    public ReviewUpdateQuery setResolution(String resolution) {
        this.resolution = resolution;
        return this;
    }

    @Override
    public String getUrl() {
        StringBuilder url = new StringBuilder();
        url.append("/api/reviews").append('/').append(this.action).append('/').append(this.reviewId).append('?');
        ReviewUpdateQuery.appendUrlParameter(url, "assignee", this.getAssignee());
        ReviewUpdateQuery.appendUrlParameter(url, "resolution", this.getResolution());
        return url.toString();
    }

    @Override
    public String getBody() {
        return this.comment;
    }

    @Override
    public Class<Review> getModelClass() {
        return Review.class;
    }
}

