/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.wsclient.services;

import org.sonar.wsclient.services.CreateQuery;
import org.sonar.wsclient.services.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyCreateQuery
extends CreateQuery<Property> {
    private String key;
    private String value;
    private String resourceKeyOrId;

    public PropertyCreateQuery() {
    }

    public PropertyCreateQuery(String key, String value) {
        this.key = key;
        this.value = value;
    }

    public PropertyCreateQuery(String key, String value, String resourceKeyOrId) {
        this.key = key;
        this.value = value;
        this.resourceKeyOrId = resourceKeyOrId;
    }

    public PropertyCreateQuery(Property property) {
        this.key = property.getKey();
        this.value = property.getValue();
    }

    public String getKey() {
        return this.key;
    }

    public PropertyCreateQuery setKey(String key) {
        this.key = key;
        return this;
    }

    public String getValue() {
        return this.value;
    }

    public PropertyCreateQuery setValue(String value) {
        this.value = value;
        return this;
    }

    public String getResourceKeyOrId() {
        return this.resourceKeyOrId;
    }

    public PropertyCreateQuery setResourceKeyOrId(String resourceKeyOrId) {
        this.resourceKeyOrId = resourceKeyOrId;
        return this;
    }

    @Override
    public String getUrl() {
        StringBuilder url = new StringBuilder();
        url.append("/api/properties");
        url.append("/").append(PropertyCreateQuery.encode(this.key));
        url.append('?');
        PropertyCreateQuery.appendUrlParameter(url, "value", this.value);
        PropertyCreateQuery.appendUrlParameter(url, "resource", this.resourceKeyOrId);
        return url.toString();
    }

    @Override
    public String getBody() {
        return this.value;
    }

    @Override
    public Class<Property> getModelClass() {
        return Property.class;
    }
}

