/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.wsclient.connectors;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.sonar.wsclient.Host;
import org.sonar.wsclient.connectors.ConnectionException;
import org.sonar.wsclient.connectors.Connector;
import org.sonar.wsclient.services.AbstractQuery;
import org.sonar.wsclient.services.CreateQuery;
import org.sonar.wsclient.services.DeleteQuery;
import org.sonar.wsclient.services.Query;
import org.sonar.wsclient.services.UpdateQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpClient4Connector
extends Connector {
    private Host server;

    public HttpClient4Connector(Host server) {
        this.server = server;
    }

    @Override
    public String execute(Query<?> query) {
        return this.executeRequest((HttpRequestBase)this.newGetMethod(query));
    }

    @Override
    public String execute(CreateQuery<?> query) {
        return this.executeRequest((HttpRequestBase)this.newPostMethod(query));
    }

    @Override
    public String execute(UpdateQuery<?> query) {
        return this.executeRequest((HttpRequestBase)this.newPutMethod(query));
    }

    @Override
    public String execute(DeleteQuery<?> query) {
        return this.executeRequest((HttpRequestBase)this.newDeleteMethod(query));
    }

    private String executeRequest(HttpRequestBase request) {
        String json = null;
        DefaultHttpClient client = this.createClient();
        try {
            BasicHttpContext context = this.createLocalContext(client);
            HttpResponse response = client.execute((HttpUriRequest)request, (HttpContext)context);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                if (response.getStatusLine().getStatusCode() == 200) {
                    json = EntityUtils.toString((HttpEntity)entity);
                } else if (response.getStatusLine().getStatusCode() != 404) {
                    throw new ConnectionException("HTTP error: " + response.getStatusLine().getStatusCode() + ", msg: " + response.getStatusLine().getReasonPhrase() + ", query: " + request.toString());
                }
            }
        }
        catch (IOException e) {
            throw new ConnectionException("Query: " + request.getURI(), e);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
        return json;
    }

    private DefaultHttpClient createClient() {
        DefaultHttpClient client = new DefaultHttpClient();
        HttpParams params = client.getParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)30000);
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)30000);
        if (this.server.getUsername() != null) {
            client.getCredentialsProvider().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.server.getUsername(), this.server.getPassword()));
        }
        return client;
    }

    private BasicHttpContext createLocalContext(DefaultHttpClient client) {
        BasicHttpContext localcontext = new BasicHttpContext();
        if (this.server.getUsername() != null) {
            BasicScheme basicAuth = new BasicScheme();
            localcontext.setAttribute("preemptive-auth", (Object)basicAuth);
            client.addRequestInterceptor((HttpRequestInterceptor)new PreemptiveAuth(), 0);
        }
        return localcontext;
    }

    private HttpGet newGetMethod(Query<?> query) {
        HttpGet get = new HttpGet(this.server.getHost() + query.getUrl());
        this.setJsonHeader((HttpRequestBase)get);
        return get;
    }

    private HttpDelete newDeleteMethod(DeleteQuery<?> query) {
        HttpDelete delete = new HttpDelete(this.server.getHost() + query.getUrl());
        this.setJsonHeader((HttpRequestBase)delete);
        return delete;
    }

    private HttpPost newPostMethod(CreateQuery<?> query) {
        HttpPost post = new HttpPost(this.server.getHost() + query.getUrl());
        this.setJsonHeader((HttpRequestBase)post);
        this.setRequestEntity((HttpEntityEnclosingRequestBase)post, query);
        return post;
    }

    private HttpPut newPutMethod(UpdateQuery<?> query) {
        HttpPut put = new HttpPut(this.server.getHost() + query.getUrl());
        this.setJsonHeader((HttpRequestBase)put);
        this.setRequestEntity((HttpEntityEnclosingRequestBase)put, query);
        return put;
    }

    private void setRequestEntity(HttpEntityEnclosingRequestBase request, AbstractQuery<?> query) {
        if (query.getBody() != null) {
            try {
                request.setEntity((HttpEntity)new StringEntity(query.getBody(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new ConnectionException("Encoding is not supported", e);
            }
        }
    }

    private void setJsonHeader(HttpRequestBase request) {
        request.setHeader("Accept", "application/json");
    }

    static final class PreemptiveAuth
    implements HttpRequestInterceptor {
        PreemptiveAuth() {
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException {
            AuthState authState = (AuthState)context.getAttribute("http.auth.target-scope");
            if (authState.getAuthScheme() == null) {
                AuthScheme authScheme = (AuthScheme)context.getAttribute("preemptive-auth");
                CredentialsProvider credsProvider = (CredentialsProvider)context.getAttribute("http.auth.credentials-provider");
                HttpHost targetHost = (HttpHost)context.getAttribute("http.target_host");
                if (authScheme != null) {
                    Credentials creds = credsProvider.getCredentials(new AuthScope(targetHost.getHostName(), targetHost.getPort()));
                    if (creds == null) {
                        throw new HttpException("No credentials for preemptive authentication");
                    }
                    authState.setAuthScheme(authScheme);
                    authState.setCredentials(creds);
                }
            }
        }
    }
}

