/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.wsclient;

import java.util.Collections;
import java.util.List;
import org.sonar.wsclient.Host;
import org.sonar.wsclient.JdkUtils;
import org.sonar.wsclient.connectors.Connector;
import org.sonar.wsclient.connectors.ConnectorFactory;
import org.sonar.wsclient.services.CreateQuery;
import org.sonar.wsclient.services.DeleteQuery;
import org.sonar.wsclient.services.Model;
import org.sonar.wsclient.services.Query;
import org.sonar.wsclient.services.UpdateQuery;
import org.sonar.wsclient.services.WSUtils;
import org.sonar.wsclient.unmarshallers.Unmarshaller;
import org.sonar.wsclient.unmarshallers.Unmarshallers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sonar {
    private Connector connector;

    public Sonar(Connector connector) {
        this.connector = connector;
    }

    public Connector getConnector() {
        return this.connector;
    }

    public <MODEL extends Model> MODEL find(Query<MODEL> query) {
        String json = this.connector.execute(query);
        MODEL result = null;
        if (json != null) {
            Unmarshaller<MODEL> unmarshaller = Unmarshallers.forModel(query.getModelClass());
            result = unmarshaller.toModel(json);
        }
        return result;
    }

    public <MODEL extends Model> List<MODEL> findAll(Query<MODEL> query) {
        List<Object> result;
        String json = this.connector.execute(query);
        if (json == null) {
            result = Collections.emptyList();
        } else {
            Unmarshaller<MODEL> unmarshaller = Unmarshallers.forModel(query.getModelClass());
            result = unmarshaller.toModels(json);
        }
        return result;
    }

    public <MODEL extends Model> MODEL create(CreateQuery<MODEL> query) {
        String json = this.connector.execute(query);
        MODEL result = null;
        if (json != null) {
            Unmarshaller<MODEL> unmarshaller = Unmarshallers.forModel(query.getModelClass());
            result = unmarshaller.toModel(json);
        }
        return result;
    }

    public void update(UpdateQuery<?> query) {
        this.connector.execute(query);
    }

    public void delete(DeleteQuery<?> query) {
        this.connector.execute(query);
    }

    public static Sonar create(String host) {
        return new Sonar(ConnectorFactory.create(new Host(host)));
    }

    public static Sonar create(String host, String username, String password) {
        return new Sonar(ConnectorFactory.create(new Host(host, username, password)));
    }

    static {
        WSUtils.setInstance(new JdkUtils());
    }
}

