/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.jpa.session;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.NonUniqueResultException;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.database.DatabaseSession;
import org.sonar.jpa.session.DatabaseConnector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaDatabaseSession
extends DatabaseSession {
    private final DatabaseConnector connector;
    private EntityManager entityManager = null;
    private int index = 0;
    private boolean inTransaction = false;

    public JpaDatabaseSession(DatabaseConnector connector) {
        this.connector = connector;
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void start() {
        this.entityManager = this.connector.createEntityManager();
        this.index = 0;
    }

    public void stop() {
        this.commit();
        if (this.entityManager != null && this.entityManager.isOpen()) {
            this.entityManager.close();
            this.entityManager = null;
        }
    }

    public void commit() {
        if (this.entityManager != null && this.inTransaction) {
            if (this.entityManager.isOpen()) {
                if (this.entityManager.getTransaction().getRollbackOnly()) {
                    this.entityManager.getTransaction().rollback();
                } else {
                    this.entityManager.getTransaction().commit();
                }
                this.entityManager.clear();
                this.index = 0;
            }
            this.inTransaction = false;
        }
    }

    public void rollback() {
        if (this.entityManager != null && this.inTransaction) {
            this.entityManager.getTransaction().rollback();
            this.inTransaction = false;
        }
    }

    public <T> T save(T model) {
        this.startTransaction();
        this.internalSave(model, true);
        return model;
    }

    public Object saveWithoutFlush(Object model) {
        this.startTransaction();
        this.internalSave(model, false);
        return model;
    }

    public boolean contains(Object model) {
        this.startTransaction();
        return this.entityManager.contains(model);
    }

    public void save(Object ... models) {
        this.startTransaction();
        for (Object model : models) {
            this.save((T)model);
        }
    }

    private void internalSave(Object model, boolean flushIfNeeded) {
        try {
            this.entityManager.persist(model);
        }
        catch (PersistenceException e) {
            throw new PersistenceException("Unable to persist : " + model, (Throwable)e);
        }
        if (flushIfNeeded && ++this.index % 30 == 0) {
            this.commit();
        }
    }

    public Object merge(Object model) {
        this.startTransaction();
        return this.entityManager.merge(model);
    }

    public void remove(Object model) {
        this.startTransaction();
        this.entityManager.remove(model);
        if (++this.index % 30 == 0) {
            this.commit();
        }
    }

    public void removeWithoutFlush(Object model) {
        this.startTransaction();
        this.entityManager.remove(model);
    }

    public <T> T reattach(Class<T> entityClass, Object primaryKey) {
        this.startTransaction();
        return (T)this.entityManager.getReference(entityClass, primaryKey);
    }

    private void startTransaction() {
        if (!this.inTransaction) {
            this.entityManager.getTransaction().begin();
            this.inTransaction = true;
        }
    }

    public Query createQuery(String hql) {
        this.startTransaction();
        return this.entityManager.createQuery(hql);
    }

    public Query createNativeQuery(String sql) {
        this.startTransaction();
        return this.entityManager.createNativeQuery(sql);
    }

    public <T> T getSingleResult(Query query, T defaultValue) {
        List result = query.getResultList();
        if (result.size() == 1) {
            return (T)result.get(0);
        }
        if (result.isEmpty()) {
            return defaultValue;
        }
        HashSet uniqueResult = new HashSet(result);
        if (uniqueResult.size() > 1) {
            throw new NonUniqueResultException("Expected single result, but got : " + result.toString());
        }
        return (T)uniqueResult.iterator().next();
    }

    public <T> T getEntity(Class<T> entityClass, Object id) {
        this.startTransaction();
        return (T)this.getEntityManager().find(entityClass, id);
    }

    public <T> T getSingleResult(Class<T> entityClass, Object ... criterias) {
        try {
            return (T)this.getSingleResult(this.getQueryForCriterias(entityClass, true, criterias), null);
        }
        catch (NonUniqueResultException ex) {
            NonUniqueResultException e = new NonUniqueResultException("Expected single result for entitiy " + entityClass.getSimpleName() + " with criterias : " + StringUtils.join((Object[])criterias, (String)","));
            e.initCause((Throwable)ex);
            throw e;
        }
    }

    public <T> List<T> getResults(Class<T> entityClass, Object ... criterias) {
        return this.getQueryForCriterias(entityClass, true, criterias).getResultList();
    }

    public <T> List<T> getResults(Class<T> entityClass) {
        return this.getQueryForCriterias(entityClass, false, null).getResultList();
    }

    private Query getQueryForCriterias(Class<?> entityClass, boolean raiseError, Object ... criterias) {
        if (criterias == null && raiseError) {
            throw new IllegalStateException("criterias parameter must be provided");
        }
        this.startTransaction();
        StringBuilder hql = new StringBuilder("SELECT o FROM ").append(entityClass.getSimpleName()).append(" o");
        if (criterias != null) {
            hql.append(" WHERE ");
            HashMap<String, Object> mappedCriterias = new HashMap<String, Object>();
            for (int i = 0; i < criterias.length; i += 2) {
                mappedCriterias.put((String)criterias[i], criterias[i + 1]);
            }
            this.buildCriteriasHQL(hql, mappedCriterias);
            Query query = this.getEntityManager().createQuery(hql.toString());
            for (Map.Entry entry : mappedCriterias.entrySet()) {
                query.setParameter((String)entry.getKey(), entry.getValue());
            }
            return query;
        }
        return this.getEntityManager().createQuery(hql.toString());
    }

    private void buildCriteriasHQL(StringBuilder hql, Map<String, Object> mappedCriterias) {
        Iterator<String> i = mappedCriterias.keySet().iterator();
        while (i.hasNext()) {
            String criteria = i.next();
            hql.append("o.").append(criteria).append("=:").append(criteria);
            if (!i.hasNext()) continue;
            hql.append(" AND ");
        }
    }
}

