/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.jpa.session;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.sonar.jpa.session.AbstractDatabaseConnector;
import org.sonar.jpa.session.DriverProxy;

public class DriverDatabaseConnector
extends AbstractDatabaseConnector {
    private ClassLoader classloader;

    public DriverDatabaseConnector(Configuration configuration) {
        super(configuration, true);
        this.classloader = this.getClass().getClassLoader();
    }

    public DriverDatabaseConnector(Configuration configuration, ClassLoader classloader) {
        super(configuration, true);
        this.classloader = classloader;
    }

    public String getDriver() {
        String driver = this.getConfiguration().getString("sonar.jdbc.driverClassName");
        if (driver == null) {
            driver = this.getConfiguration().getString("sonar.jdbc.driver");
        }
        if (driver == null) {
            driver = "org.apache.derby.jdbc.ClientDriver";
        }
        return driver;
    }

    public String getUrl() {
        return this.getConfiguration().getString("sonar.jdbc.url", "jdbc:derby://localhost:1527/sonar");
    }

    public String getUsername() {
        String username = this.getConfiguration().getString("sonar.jdbc.username");
        if (username == null) {
            username = this.getConfiguration().getString("sonar.jdbc.user");
        }
        if (username == null) {
            username = "sonar";
        }
        return username;
    }

    public String getPassword() {
        return this.getConfiguration().getString("sonar.jdbc.password", "sonar");
    }

    public Connection getConnection() throws SQLException {
        try {
            Driver driver = (Driver)this.classloader.loadClass(this.getDriver()).newInstance();
            DriverManager.registerDriver(new DriverProxy(driver));
        }
        catch (Exception e) {
            SQLException ex = new SQLException("SQL driver not found " + this.getDriver());
            ex.initCause(e);
            throw ex;
        }
        return DriverManager.getConnection(this.getUrl(), this.getUsername(), this.getPassword());
    }

    public void setupEntityManagerFactory(Properties factoryProps) {
        factoryProps.put("hibernate.connection.url", this.getUrl());
        factoryProps.put("hibernate.connection.driver_class", this.getDriver());
        factoryProps.put("hibernate.connection.username", this.getUsername());
        if (StringUtils.isNotEmpty((String)this.getPassword())) {
            factoryProps.put("hibernate.connection.password", this.getPassword());
        }
    }
}

