/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.jpa.session;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.utils.Logs;
import org.sonar.jpa.dialect.Dialect;
import org.sonar.jpa.dialect.DialectRepository;
import org.sonar.jpa.entity.SchemaMigration;
import org.sonar.jpa.session.DatabaseConnector;
import org.sonar.jpa.session.DatabaseException;

public abstract class AbstractDatabaseConnector
implements DatabaseConnector {
    protected static final Logger LOG_SQL = LoggerFactory.getLogger((String)"org.hibernate.SQL");
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractDatabaseConnector.class);
    private Configuration configuration = null;
    private EntityManagerFactory factory = null;
    private int databaseVersion = -1;
    private boolean operational = false;
    private boolean started = false;
    private boolean startsFailIfSchemaOutdated;
    private Integer transactionIsolation = null;
    private Dialect dialect = null;

    protected AbstractDatabaseConnector(Configuration configuration, boolean startsFailIfSchemaOutdated) {
        this.configuration = configuration;
        this.startsFailIfSchemaOutdated = startsFailIfSchemaOutdated;
    }

    protected AbstractDatabaseConnector() {
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public String getDialectId() {
        return this.dialect.getId();
    }

    public boolean isOperational() {
        return this.operational;
    }

    protected boolean isStarted() {
        return this.started;
    }

    public final Integer getTransactionIsolation() {
        return this.transactionIsolation;
    }

    public void start() {
        if (!this.started) {
            this.transactionIsolation = this.configuration.getInteger("sonar.jdbc.defaultTransactionIsolation", null);
            String jdbcConnectionUrl = this.testConnection();
            this.dialect = DialectRepository.find(this.configuration.getString("sonar.jdbc.dialect"), jdbcConnectionUrl);
            LoggerFactory.getLogger((String)"org.sonar.INFO").info("Database dialect class " + this.dialect.getClass().getName());
            this.started = true;
        }
        if (!this.operational) {
            boolean upToDate = this.upToDateSchemaVersion();
            if (!upToDate && this.startsFailIfSchemaOutdated) {
                throw new DatabaseException(this.databaseVersion, 191);
            }
            if (upToDate) {
                Logs.INFO.info("Initializing Hibernate");
                this.factory = this.createEntityManagerFactory();
                this.operational = true;
            }
        }
    }

    public void stop() {
        if (this.factory != null && this.factory.isOpen()) {
            this.factory.close();
            this.factory = null;
        }
        this.operational = false;
        this.started = false;
    }

    public abstract void setupEntityManagerFactory(Properties var1);

    public EntityManagerFactory getEntityManagerFactory() {
        return this.factory;
    }

    protected void setEntityManagerFactory(EntityManagerFactory factory) {
        this.factory = factory;
    }

    protected EntityManagerFactory createEntityManagerFactory() {
        Properties props = this.getHibernateProperties();
        this.logHibernateSettings(props);
        return Persistence.createEntityManagerFactory((String)"sonar", (Map)props);
    }

    private void logHibernateSettings(Properties props) {
        if (LOG.isDebugEnabled()) {
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                LOG.debug(entry.getKey() + ": " + entry.getValue());
            }
        }
    }

    protected Properties getHibernateProperties() {
        Properties props = new Properties();
        if (this.transactionIsolation != null) {
            props.put("hibernate.connection.isolation", Integer.toString(this.transactionIsolation));
        }
        props.put("hibernate.hbm2ddl.auto", this.getConfiguration().getString("sonar.jdbc.hibernate.hbm2ddl", "validate"));
        props.put("hibernate.dialect", this.getDialectClass());
        props.put("hibernate.generate_statistics", (Object)this.getConfiguration().getBoolean("sonar.jdbc.hibernate.generate_statistics", false));
        props.put("hibernate.show_sql", Boolean.valueOf(LOG_SQL.isDebugEnabled()).toString());
        Configuration subset = this.getConfiguration().subset("sonar.hibernate");
        Iterator keys = subset.getKeys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (!StringUtils.isNotBlank((String)((String)subset.getProperty(key)))) continue;
            props.put("hibernate." + key, subset.getProperty(key));
        }
        this.setupEntityManagerFactory(props);
        return props;
    }

    public EntityManager createEntityManager() {
        return this.factory.createEntityManager();
    }

    private String testConnection() throws DatabaseException {
        Connection connection = null;
        try {
            connection = this.getConnection();
            String string = connection.getMetaData().getURL();
            return string;
        }
        catch (SQLException e) {
            throw new DatabaseException("Cannot open connection to database: " + e.getMessage(), e);
        }
        finally {
            this.close(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int loadVersion() {
        Connection connection = null;
        try {
            connection = this.getConnection();
            int n = SchemaMigration.getCurrentVersion(connection);
            return n;
        }
        catch (SQLException e) {
            int n = 0;
            return n;
        }
        finally {
            this.close(connection);
        }
    }

    private void close(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    protected boolean upToDateSchemaVersion() {
        if (this.databaseVersion == 191) {
            return true;
        }
        this.databaseVersion = this.loadVersion();
        return this.databaseVersion == 191;
    }

    public final int getDatabaseVersion() {
        return this.databaseVersion;
    }

    public final Dialect getDialect() {
        return this.dialect;
    }

    public final String getDialectClass() {
        String dialectClass = this.configuration.getString("sonar.jdbc.dialectClass");
        if (dialectClass == null && this.dialect != null) {
            dialectClass = this.dialect.getHibernateDialectClass().getName();
        }
        return dialectClass;
    }
}

