/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.jpa.dialect;

import java.util.Properties;
import org.hibernate.MappingException;
import org.hibernate.dialect.Dialect;
import org.hibernate.id.SequenceGenerator;
import org.hibernate.type.Type;

public class PostgreSQLSequenceGenerator
extends SequenceGenerator {
    public static final String SEQUENCE_NAME_SEPARATOR = "_";
    public static final String SEQUENCE_NAME_SUFFIX = "seq";

    public void configure(Type type, Properties params, Dialect dialect) throws MappingException {
        String tableName = params.getProperty("target_table");
        String columnName = params.getProperty("target_column");
        if (tableName != null && columnName != null) {
            StringBuilder sequenceNameBuilder = new StringBuilder();
            sequenceNameBuilder.append(tableName);
            sequenceNameBuilder.append(SEQUENCE_NAME_SEPARATOR);
            sequenceNameBuilder.append(columnName);
            sequenceNameBuilder.append(SEQUENCE_NAME_SEPARATOR);
            sequenceNameBuilder.append(SEQUENCE_NAME_SUFFIX);
            params.setProperty("sequence", sequenceNameBuilder.toString());
        }
        super.configure(type, params, dialect);
    }
}

