/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.jpa.dialect;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.utils.SonarException;
import org.sonar.jpa.dialect.Derby;
import org.sonar.jpa.dialect.Dialect;
import org.sonar.jpa.dialect.HsqlDb;
import org.sonar.jpa.dialect.MsSql;
import org.sonar.jpa.dialect.MySql;
import org.sonar.jpa.dialect.Oracle;
import org.sonar.jpa.dialect.PostgreSql;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DialectRepository {
    private static List<Dialect> builtInDialects = DialectRepository.getSupportedDialects();

    private DialectRepository() {
    }

    public static Dialect find(String dialectId, String jdbcConnectionUrl) {
        Dialect match;
        Dialect dialect = match = StringUtils.isNotEmpty((String)dialectId) ? DialectRepository.findById(dialectId) : DialectRepository.findByJdbcUrl(jdbcConnectionUrl);
        if (match == null) {
            throw new SonarException("Unable to determine database dialect to use within sonar with dialect " + dialectId + " jdbc url " + jdbcConnectionUrl);
        }
        return match;
    }

    private static Dialect findByJdbcUrl(final String jdbcConnectionUrl) {
        Dialect match = DialectRepository.findDialect(builtInDialects, new Predicate<Dialect>(){

            public boolean apply(Dialect dialect) {
                return dialect.matchesJdbcURL(StringUtils.trimToEmpty((String)jdbcConnectionUrl));
            }
        });
        return match;
    }

    private static Dialect findById(final String dialectId) {
        Dialect match = DialectRepository.findDialect(builtInDialects, new Predicate<Dialect>(){

            public boolean apply(Dialect dialect) {
                return dialect.getId().equals(dialectId);
            }
        });
        match = match == null ? DialectRepository.getDialectByClassname(dialectId) : match;
        return match;
    }

    private static Dialect findDialect(Collection<Dialect> dialects, Predicate<Dialect> predicate) {
        try {
            return (Dialect)Iterators.find(dialects.iterator(), predicate);
        }
        catch (NoSuchElementException ex) {
            return null;
        }
    }

    private static Dialect getDialectByClassname(String dialectId) {
        try {
            Class<?> dialectClass = DialectRepository.class.getClassLoader().loadClass(dialectId);
            return (Dialect)dialectClass.newInstance();
        }
        catch (ClassNotFoundException e) {
        }
        catch (Exception e) {
            throw new SonarException("Unable to instanciate dialect class", (Throwable)e);
        }
        return null;
    }

    private static List<Dialect> getSupportedDialects() {
        return Arrays.asList(new Derby(), new HsqlDb(), new MySql(), new Oracle(), new PostgreSql(), new MsSql());
    }
}

