/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.jpa.dao;

import java.util.Date;
import java.util.List;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import org.sonar.api.database.DatabaseSession;
import org.sonar.api.database.model.AsyncMeasureSnapshot;
import org.sonar.api.database.model.MeasureModel;
import org.sonar.api.database.model.Snapshot;
import org.sonar.jpa.dao.BaseDao;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncMeasuresDao
extends BaseDao {
    public AsyncMeasuresDao(DatabaseSession session) {
        super(session);
    }

    public MeasureModel getAsyncMeasure(Long asyncMeasureId) {
        return (MeasureModel)this.getSession().getEntityManager().find(MeasureModel.class, (Object)asyncMeasureId);
    }

    public void deleteAsyncMeasure(MeasureModel asyncMeasure) {
        this.deleteAsyncMeasureSnapshots(asyncMeasure.getId());
        this.getSession().remove((Object)asyncMeasure);
    }

    public Snapshot getPreviousSnapshot(Snapshot s) {
        try {
            return (Snapshot)this.getSession().createQuery("SELECT s FROM Snapshot s WHERE s.createdAt<:date AND s.scope=:scope AND s.resourceId=:resourceId ORDER BY s.createdAt DESC").setParameter("date", (Object)s.getCreatedAt()).setParameter("scope", (Object)s.getScope()).setParameter("resourceId", (Object)s.getResourceId()).setMaxResults(1).getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
    }

    public List<Snapshot> getNextSnapshotsUntilDate(MeasureModel measure, Date date) {
        Query query = this.getSession().createQuery("SELECT s FROM Snapshot s WHERE s.resourceId=:projectId AND s.createdAt>=:beginDate " + (date != null ? "AND s.createdAt<:endDate " : "") + "AND s.scope=:scope " + "ORDER BY s.createdAt ASC ").setParameter("projectId", (Object)measure.getProjectId()).setParameter("beginDate", (Object)measure.getMeasureDate()).setParameter("scope", (Object)"PRJ");
        if (date != null) {
            query.setParameter("endDate", (Object)date);
        }
        return query.getResultList();
    }

    public AsyncMeasureSnapshot createAsyncMeasureSnapshot(Long asyncMeasureId, Integer snapshotId, Date AsyncMeasureDate, Date snapshotDate, Integer metricId, Integer projectId) {
        AsyncMeasureSnapshot asyncMeasureSnapshot = new AsyncMeasureSnapshot(asyncMeasureId, snapshotId, AsyncMeasureDate, snapshotDate, metricId, projectId);
        this.getSession().save((Object)asyncMeasureSnapshot);
        return asyncMeasureSnapshot;
    }

    public void updateAsyncMeasureSnapshot(AsyncMeasureSnapshot asyncMeasureSnapshot, Snapshot snapshot) {
        if (snapshot != null) {
            asyncMeasureSnapshot.setSnapshotId(snapshot.getId());
            asyncMeasureSnapshot.setSnapshotDate(snapshot.getCreatedAt());
        } else {
            asyncMeasureSnapshot.setSnapshotId(null);
            asyncMeasureSnapshot.setSnapshotDate(null);
        }
        this.getSession().merge((Object)asyncMeasureSnapshot);
    }

    public void removeSnapshotFromAsyncMeasureSnapshot(AsyncMeasureSnapshot asyncMeasureSnapshot) {
        asyncMeasureSnapshot.setSnapshotId(null);
        asyncMeasureSnapshot.setSnapshotDate(null);
        this.getSession().merge((Object)asyncMeasureSnapshot);
    }

    public AsyncMeasureSnapshot getNextAsyncMeasureSnapshot(Integer projetcId, Integer metricId, Date date) {
        try {
            return (AsyncMeasureSnapshot)this.getSession().createQuery("SELECT ams FROM AsyncMeasureSnapshot ams WHERE ams.projectId=:projectId AND ams.metricId=:metricId AND ams.measureDate>:date ORDER BY ams.measureDate ASC").setParameter("projectId", (Object)projetcId).setParameter("metricId", (Object)metricId).setParameter("date", (Object)date).setMaxResults(1).getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
    }

    public List<AsyncMeasureSnapshot> getNextAsyncMeasureSnapshotsUntilDate(MeasureModel asyncMeasure, Date endDate) {
        Query query = this.getSession().createQuery("SELECT ams FROM AsyncMeasureSnapshot ams WHERE ams.projectId=:projectId AND ams.metricId=:metricId " + (endDate != null ? "AND ams.measureDate<:endDate " : "") + "AND ams.snapshotDate>=:measureDate " + "ORDER BY ams.snapshotDate ASC ").setParameter("projectId", (Object)asyncMeasure.getProjectId()).setParameter("metricId", (Object)asyncMeasure.getMetricId()).setParameter("measureDate", (Object)asyncMeasure.getMeasureDate());
        if (endDate != null) {
            query.setParameter("endDate", (Object)endDate);
        }
        return query.getResultList();
    }

    public List<AsyncMeasureSnapshot> getPreviousAsyncMeasureSnapshots(Integer projectId, Date beginDate, Date endDate) {
        Query query = this.getSession().createQuery("SELECT ams FROM AsyncMeasureSnapshot ams WHERE ams.projectId=:projectId AND ams.measureDate<=:endDate " + (beginDate != null ? "AND ams.measureDate>:beginDate " : "") + "AND ams.snapshotId IS NULL " + "ORDER BY ams.measureDate ASC").setParameter("projectId", (Object)projectId).setParameter("endDate", (Object)endDate);
        if (beginDate != null) {
            query.setParameter("beginDate", (Object)beginDate);
        }
        return query.getResultList();
    }

    public List<AsyncMeasureSnapshot> getAsyncMeasureSnapshotsFromSnapshotId(Integer snapshotId, List<Integer> metricIdsToExclude) {
        Query query = this.getSession().createQuery("SELECT ams FROM AsyncMeasureSnapshot ams WHERE ams.snapshotId=:snapshotId " + (!metricIdsToExclude.isEmpty() ? "AND ams.metricId NOT IN (:metricIdsToExclude) " : "") + "ORDER BY ams.measureDate ASC").setParameter("snapshotId", (Object)snapshotId);
        if (!metricIdsToExclude.isEmpty()) {
            query.setParameter("metricIdsToExclude", metricIdsToExclude);
        }
        return query.getResultList();
    }

    public AsyncMeasureSnapshot getLastAsyncMeasureSnapshot(Integer projetcId, Integer metricId, Date date) {
        try {
            return (AsyncMeasureSnapshot)this.getSession().createQuery("SELECT ams FROM AsyncMeasureSnapshot ams WHERE ams.projectId=:projectId AND ams.metricId=:metricId AND ams.measureDate<:date ORDER BY ams.measureDate DESC").setParameter("projectId", (Object)projetcId).setParameter("metricId", (Object)metricId).setParameter("date", (Object)date).setMaxResults(1).getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
    }

    public void deleteAsyncMeasureSnapshots(Long asyncMeasureId) {
        this.getSession().createQuery("DELETE FROM AsyncMeasureSnapshot ams WHERE ams.measureId=:measureId").setParameter("measureId", (Object)asyncMeasureId).executeUpdate();
    }
}

