/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.plugin;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.Query;
import org.sonar.api.BatchComponent;
import org.sonar.api.ServerComponent;
import org.sonar.api.database.DatabaseSession;
import org.sonar.core.plugin.JpaPlugin;
import org.sonar.core.plugin.JpaPluginFile;
import org.sonar.jpa.session.DatabaseSessionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaPluginDao
implements BatchComponent,
ServerComponent {
    private DatabaseSessionFactory sessionFactory;

    public JpaPluginDao(DatabaseSessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public List<JpaPlugin> getPlugins() {
        DatabaseSession session = this.sessionFactory.getSession();
        Query query = session.createQuery("FROM " + JpaPlugin.class.getSimpleName());
        return query.getResultList();
    }

    public List<JpaPluginFile> getPluginFiles() {
        DatabaseSession session = this.sessionFactory.getSession();
        Query query = session.createQuery("FROM " + JpaPluginFile.class.getSimpleName());
        return query.getResultList();
    }

    public void register(List<JpaPlugin> plugins) {
        DatabaseSession session = this.sessionFactory.getSession();
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (JpaPlugin plugin : plugins) {
            session.saveWithoutFlush((Object)plugin);
            ids.add(plugin.getId());
        }
        session.commit();
        if (ids.isEmpty()) {
            session.createQuery("DELETE " + JpaPluginFile.class.getSimpleName()).executeUpdate();
            session.createQuery("DELETE " + JpaPlugin.class.getSimpleName()).executeUpdate();
        } else {
            Query query = session.createQuery("DELETE " + JpaPluginFile.class.getSimpleName() + " WHERE plugin.id NOT IN (:ids)");
            query.setParameter("ids", ids);
            query.executeUpdate();
            query = session.createQuery("DELETE " + JpaPlugin.class.getSimpleName() + " WHERE id NOT IN (:ids)");
            query.setParameter("ids", ids);
            query.executeUpdate();
        }
        session.commit();
    }
}

