/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.plugin;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.picocontainer.Characteristics;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.Extension;
import org.sonar.api.ExtensionProvider;
import org.sonar.api.Plugin;
import org.sonar.api.Property;
import org.sonar.api.platform.PluginRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPluginRepository
implements PluginRepository {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractPluginRepository.class);
    private BiMap<String, Plugin> pluginByKey = HashBiMap.create();
    private Map<Object, Plugin> pluginByExtension = Maps.newIdentityHashMap();

    protected void registerPlugin(MutablePicoContainer container, Plugin plugin, String pluginKey) {
        LOG.debug("Register the plugin {}", (Object)pluginKey);
        this.pluginByKey.put((Object)pluginKey, (Object)plugin);
        for (Object extension : plugin.getExtensions()) {
            this.registerExtension(container, plugin, pluginKey, extension);
        }
    }

    protected void invokeExtensionProviders(MutablePicoContainer container) {
        List providers = container.getComponents(ExtensionProvider.class);
        for (ExtensionProvider provider : providers) {
            Plugin plugin = this.getPluginForExtension(provider);
            Object obj = provider.provide();
            if (obj instanceof Iterable) {
                for (Object elt : (Iterable)obj) {
                    this.registerExtension(container, plugin, this.getPluginKey(plugin), elt);
                }
                continue;
            }
            this.registerExtension(container, plugin, this.getPluginKey(plugin), obj);
        }
    }

    private void registerExtension(MutablePicoContainer container, Plugin plugin, String pluginKey, Object extension) {
        if (this.shouldRegisterExtension((PicoContainer)container, pluginKey, extension)) {
            LOG.debug("Register the extension: {}", extension);
            container.as(new Properties[]{Characteristics.CACHE}).addComponent(AbstractPluginRepository.getExtensionKey(extension), extension, new Parameter[0]);
            this.pluginByExtension.put(extension, plugin);
        }
    }

    protected abstract boolean shouldRegisterExtension(PicoContainer var1, String var2, Object var3);

    public Collection<Plugin> getPlugins() {
        return this.pluginByKey.values();
    }

    public Plugin getPlugin(String key) {
        return (Plugin)this.pluginByKey.get((Object)key);
    }

    public String getPluginKey(Plugin plugin) {
        return (String)this.pluginByKey.inverse().get((Object)plugin);
    }

    public Property[] getProperties(Plugin plugin) {
        Class<?> classInstance;
        if (plugin != null && (classInstance = plugin.getClass()).isAnnotationPresent(org.sonar.api.Properties.class)) {
            return classInstance.getAnnotation(org.sonar.api.Properties.class).value();
        }
        return new Property[0];
    }

    public Property[] getProperties(String pluginKey) {
        return this.getProperties((Plugin)this.pluginByKey.get((Object)pluginKey));
    }

    public Plugin getPluginForExtension(Object extension) {
        Plugin plugin = this.pluginByExtension.get(extension);
        if (plugin == null && !(extension instanceof Class)) {
            plugin = this.pluginByExtension.get(extension.getClass());
        }
        return plugin;
    }

    protected static boolean isType(Object extension, Class<? extends Extension> extensionClass) {
        Class<?> clazz = extension instanceof Class ? (Class<?>)extension : extension.getClass();
        return extensionClass.isAssignableFrom(clazz);
    }

    protected static boolean isExtensionProvider(Object extension) {
        return AbstractPluginRepository.isType(extension, ExtensionProvider.class);
    }

    protected static Object getExtensionKey(Object component) {
        if (component instanceof Class) {
            return component;
        }
        return component.getClass().getCanonicalName() + "-" + component.toString();
    }
}

