/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.components;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.sonar.api.rules.Rule;
import org.sonar.core.components.DefaultRuleFinder;
import org.sonar.jpa.session.DatabaseSessionFactory;

public final class CacheRuleFinder
extends DefaultRuleFinder {
    private BiMap<Integer, Rule> rulesById = HashBiMap.create();
    private Map<String, Map<String, Rule>> rulesByKey = Maps.newHashMap();

    public CacheRuleFinder(DatabaseSessionFactory sessionFactory) {
        super(sessionFactory);
    }

    public Rule findById(int ruleId) {
        Rule rule = (Rule)this.rulesById.get((Object)ruleId);
        if (rule == null) {
            rule = this.doFindById(ruleId);
            this.addToCache(rule);
        }
        return rule;
    }

    public Rule findByKey(String repositoryKey, String key) {
        Map<String, Rule> repoRules = this.rulesByKey.get(repositoryKey);
        Rule rule = null;
        if (repoRules != null) {
            rule = repoRules.get(key);
        }
        if (rule == null) {
            rule = this.doFindByKey(repositoryKey, key);
            this.addToCache(rule);
        }
        return rule;
    }

    private void addToCache(Rule rule) {
        if (rule != null) {
            this.rulesById.put((Object)rule.getId(), (Object)rule);
            HashMap repoRules = this.rulesByKey.get(rule.getKey());
            if (repoRules == null) {
                repoRules = Maps.newHashMap();
                this.rulesByKey.put(rule.getRepositoryKey(), repoRules);
            }
            repoRules.put(rule.getKey(), rule);
        }
    }
}

